/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScopeResolver {
    private static final Logger log = LogManager.getLogger(ScopeResolver.class);
    @Autowired
    CollectionService collectionService;
    @Autowired
    CommunityService communityService;

    public IndexableObject resolveScope(Context context, String scope) {
        IndexableCommunity scopeObj = null;
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            try {
                UUID uuid = UUID.fromString(scope);
                scopeObj = new IndexableCommunity((Community)this.communityService.find(context, uuid));
                if (scopeObj.getIndexedObject() == null) {
                    scopeObj = new IndexableCollection((Collection)this.collectionService.find(context, uuid));
                }
            }
            catch (IllegalArgumentException ex) {
                log.warn("The given scope string " + StringUtils.trimToEmpty((String)scope) + " is not a UUID", (Throwable)ex);
            }
            catch (SQLException ex) {
                log.warn("Unable to retrieve DSpace Object with ID " + StringUtils.trimToEmpty((String)scope) + " from the database", (Throwable)ex);
            }
        }
        return scopeObj;
    }
}

