/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageRelationships", description="It can be used to verify if the user has permissions to manage relationships of the Item")
public class CanManageRelationshipsFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageRelationships";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof ItemRest) {
            DSpaceObject dSpaceObject = (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object);
            return this.authorizeService.authorizeActionBoolean(context, context.getCurrentUser(), dSpaceObject, 1, true);
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

