/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
public class ItemWithdrawReplaceOperation<R>
extends PatchOperation<R> {
    private static final String OPERATION_PATH_WITHDRAW = "/withdrawn";
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        boolean withdraw = this.getBooleanOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            Item item = (Item)object;
            try {
                if (withdraw) {
                    if (item.getTemplateItemOf() != null) {
                        throw new UnprocessableEntityException("A template item cannot be withdrawn.");
                    }
                    if (!item.isWithdrawn() && !item.isArchived()) {
                        throw new UnprocessableEntityException("Cannot withdraw item when it is not in archive.");
                    }
                    if (item.isWithdrawn()) {
                        return object;
                    }
                    itemService.withdraw(context, item);
                    return object;
                }
                if (!item.isWithdrawn()) {
                    return object;
                }
                itemService.reinstate(context, item);
                return object;
            }
            catch (AuthorizeException e) {
                throw new RESTAuthorizationException("Unauthorized user for item withdrawal/reinstation");
            }
            catch (SQLException e) {
                throw new DSpaceBadRequestException("SQL exception during item withdrawal/reinstation");
            }
        }
        throw new DSpaceBadRequestException("ItemWithdrawReplaceOperation does not support this operation");
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof Item && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_WITHDRAW);
    }
}

