/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.security.WebSecurityExpressionEvaluator;
import org.dspace.app.rest.utils.Utils;
import org.dspace.services.RequestService;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ConverterService {
    private static final Logger log = LogManager.getLogger();
    private final Map<String, Projection> projectionMap = new HashMap();
    private final Map<Class, DSpaceConverter> converterMap = new HashMap();
    private final Map<Class<? extends RestModel>, Constructor> resourceConstructors = new HashMap();
    @Autowired
    private Utils utils;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    private List<DSpaceConverter> converters;
    @Autowired
    private List<Projection> projections;
    @Autowired
    private WebSecurityExpressionEvaluator webSecurityExpressionEvaluator;
    @Autowired
    private RequestService requestService;

    public <M, R> R toRest(M modelObject, Projection projection) {
        BaseObjectRest baseObjectRest;
        String preAuthorizeValue;
        Object transformedModel = projection.transformModel(modelObject);
        DSpaceConverter converter = this.requireConverter(modelObject.getClass());
        Object restObject = converter.convert(transformedModel, projection);
        if (restObject instanceof BaseObjectRest && !this.webSecurityExpressionEvaluator.evaluate(preAuthorizeValue = this.getPreAuthorizeAnnotationForBaseObject(baseObjectRest = (BaseObjectRest)restObject), this.requestService.getCurrentRequest().getHttpServletRequest(), this.requestService.getCurrentRequest().getHttpServletResponse(), String.valueOf(baseObjectRest.getId()))) {
            log.debug("Access denied on " + restObject.getClass() + " with id: " + ((BaseObjectRest)restObject).getId());
            return null;
        }
        if (restObject instanceof RestModel) {
            return (R)projection.transformRest((RestModel)restObject);
        }
        return (R)restObject;
    }

    private String getPreAuthorizeAnnotationForBaseObject(BaseObjectRest restObject) {
        Annotation preAuthorize = this.getAnnotationForRestObject(restObject);
        if (preAuthorize == null) {
            preAuthorize = this.getDefaultFindOnePreAuthorize();
        }
        return this.parseAnnotation(preAuthorize);
    }

    private String parseAnnotation(Annotation preAuthorize) {
        if (preAuthorize != null) {
            return (String)AnnotationUtils.getValue((Annotation)preAuthorize);
        }
        return null;
    }

    private Annotation getAnnotationForRestObject(BaseObjectRest restObject) {
        BaseObjectRest baseObjectRest = restObject;
        DSpaceRestRepository repositoryToUse = this.utils.getResourceRepositoryByCategoryAndModel(baseObjectRest.getCategory(), baseObjectRest.getType());
        Annotation preAuthorize = null;
        int maxDepth = 0;
        for (Method m : AopUtils.getTargetClass((Object)repositoryToUse).getMethods()) {
            int depth;
            if (!StringUtils.equalsIgnoreCase((CharSequence)m.getName(), (CharSequence)"findOne") || (depth = this.howManySuperclass(m.getDeclaringClass())) <= maxDepth) continue;
            preAuthorize = AnnotationUtils.findAnnotation((Method)m, PreAuthorize.class);
            maxDepth = depth;
        }
        return preAuthorize;
    }

    private int howManySuperclass(Class<?> declaringClass) {
        Class<?> curr = declaringClass;
        int count = 0;
        while (curr != Object.class) {
            curr = curr.getSuperclass();
            ++count;
        }
        return count;
    }

    private Annotation getDefaultFindOnePreAuthorize() {
        for (Method m : DSpaceRestRepository.class.getMethods()) {
            Annotation annotation;
            if (!StringUtils.equalsIgnoreCase((CharSequence)m.getName(), (CharSequence)"findOne") || (annotation = AnnotationUtils.findAnnotation((Method)m, PreAuthorize.class)) == null) continue;
            return annotation;
        }
        return null;
    }

    public <M, R> Page<R> toRestPage(List<M> modelObjects, Pageable pageable, Projection projection) {
        LinkedList<Object> transformedList = new LinkedList<Object>();
        for (M modelObject : modelObjects) {
            Object transformedObject = this.toRest(modelObject, projection);
            if (transformedObject == null) continue;
            transformedList.add(transformedObject);
        }
        if (pageable == null) {
            pageable = this.utils.getPageable(pageable);
        }
        return this.utils.getPage(transformedList, pageable);
    }

    public <M, R> Page<R> toRestPage(List<M> modelObjects, Pageable pageable, long total, Projection projection) {
        LinkedList<Object> transformedList = new LinkedList<Object>();
        for (M modelObject : modelObjects) {
            Object transformedObject = this.toRest(modelObject, projection);
            if (transformedObject == null) continue;
            transformedList.add(transformedObject);
        }
        if (pageable == null) {
            pageable = this.utils.getPageable(pageable);
        }
        return new PageImpl(transformedList, pageable, total);
    }

    <M, R> DSpaceConverter<M, R> getConverter(Class<M> sourceClass) {
        return this.requireConverter(sourceClass);
    }

    public <T extends HALResource> T toResource(RestModel restObject) {
        return (T)this.toResource(restObject, new Link[0]);
    }

    public <T extends HALResource> T toResource(RestModel restObject, Link ... oldLinks) {
        if (restObject == null) {
            return null;
        }
        HALResource halResource = this.getResource(restObject);
        if (restObject instanceof RestAddressableModel) {
            this.utils.embedOrLinkClassLevelRels(halResource, oldLinks);
            this.halLinkService.addLinks(halResource);
            Projection projection = ((RestAddressableModel)restObject).getProjection();
            return (T)projection.transformResource(halResource);
        }
        this.halLinkService.addLinks(halResource);
        return (T)halResource;
    }

    public Projection getProjection(@Nullable String projectionName) {
        return projectionName == null ? Projection.DEFAULT : this.requireProjection(projectionName);
    }

    private <T extends HALResource> T getResource(RestModel restObject) {
        Constructor constructor = (Constructor)this.resourceConstructors.get(restObject.getClass());
        if (constructor == null) {
            throw new IllegalArgumentException("No constructor found to get resource class from " + restObject);
        }
        try {
            if (constructor.getParameterCount() == 2) {
                return (T)((HALResource)constructor.newInstance(restObject, this.utils));
            }
            return (T)((HALResource)constructor.newInstance(restObject));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Projection requireProjection(String projectionName) {
        if (!this.projectionMap.containsKey(projectionName)) {
            throw new IllegalArgumentException("No such projection: " + projectionName);
        }
        return (Projection)this.projectionMap.get(projectionName);
    }

    private DSpaceConverter requireConverter(Class sourceClass) {
        if (this.converterMap.containsKey(sourceClass)) {
            return (DSpaceConverter)this.converterMap.get(sourceClass);
        }
        for (Class converterSourceClass : this.converterMap.keySet()) {
            if (!converterSourceClass.isAssignableFrom(sourceClass)) continue;
            return (DSpaceConverter)this.converterMap.get(converterSourceClass);
        }
        throw new IllegalArgumentException("No converter found to get rest class from " + sourceClass);
    }

    @PostConstruct
    private void initialize() {
        for (Projection projection : this.projections) {
            this.projectionMap.put(projection.getName(), projection);
        }
        this.projectionMap.put(Projection.DEFAULT.getName(), Projection.DEFAULT);
        for (DSpaceConverter converter : this.converters) {
            this.converterMap.put(converter.getModelClass(), converter);
        }
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(EntityModel.class));
        Set beanDefinitions = provider.findCandidateComponents(HALResource.class.getPackage().getName().replaceAll("\\.", "/"));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String resourceClassName = beanDefinition.getBeanClassName();
            String resourceClassSimpleName = resourceClassName.substring(resourceClassName.lastIndexOf(".") + 1);
            String restClassSimpleName = resourceClassSimpleName.replaceAll("ResourceWrapper$", "RestWrapper").replaceAll("Resource$", "Rest");
            String restClassName = RestModel.class.getPackage().getName() + "." + restClassSimpleName;
            try {
                Class<?> restClass = Class.forName(restClassName);
                Class<?> resourceClass = Class.forName(resourceClassName);
                Constructor<?> compatibleConstructor = null;
                for (Constructor<?> constructor : resourceClass.getDeclaredConstructors()) {
                    if (constructor.getParameterCount() == 2 && constructor.getParameterTypes()[1] == Utils.class) {
                        compatibleConstructor = constructor;
                        break;
                    }
                    if (constructor.getParameterCount() != 1) continue;
                    compatibleConstructor = constructor;
                }
                if (compatibleConstructor != null) {
                    this.resourceConstructors.put(restClass, compatibleConstructor);
                    continue;
                }
                log.warn("Skipping registration of resource class " + resourceClassName + "; compatible constructor not found");
            }
            catch (ClassNotFoundException e) {
                log.warn("Skipping registration of resource class " + resourceClassName + "; rest class not found: " + restClassName);
            }
        }
    }
}

