/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="versioning.versionhistory.versions")
public class VersionsLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private VersioningService versioningService;

    @PreAuthorize(value="@versioningSecurity.isEnableVersioning() && hasPermission(#versionHistoryId, 'VERSIONHISTORY', 'READ')")
    public Page<VersionRest> getVersions(@Nullable HttpServletRequest request, Integer versionHistoryId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = this.obtainContext();
        int total = 0;
        VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, versionHistoryId.intValue());
        if (versionHistory == null) {
            throw new ResourceNotFoundException("The versionHistory with ID: " + versionHistoryId + " couldn't be found");
        }
        Pageable pageable = optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
        List versions = this.versioningService.getVersionsByHistoryWithItems(context, versionHistory, Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
        total = this.versioningService.countVersionsByHistoryWithItem(context, versionHistory);
        return this.converter.toRestPage(versions, pageable, (long)total, projection);
    }
}

