/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.repository.BitstreamRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/bitstreams/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/bundle"})
public class BitstreamBundleController {
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    ConverterService converter;
    @Autowired
    HalLinkService halLinkService;
    @Autowired
    Utils utils;
    @Autowired
    BitstreamRestRepository bitstreamRestRepository;

    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"})
    @PreAuthorize(value="hasPermission(#uuid, 'BITSTREAM','WRITE')")
    @PostAuthorize(value="returnObject != null")
    public BundleRest move(@PathVariable UUID uuid, HttpServletResponse response, HttpServletRequest request) throws SQLException, IOException, AuthorizeException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        List dsoList = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (dsoList.size() != 1 || ((DSpaceObject)dsoList.get(0)).getType() != 1) {
            throw new UnprocessableEntityException("No bundle has been specified or the data cannot be resolved to a bundle.");
        }
        Bitstream bitstream = this.bitstreamService.find(context, uuid);
        if (bitstream == null) {
            throw new ResourceNotFoundException("Bitstream with id: " + uuid + " not found");
        }
        BundleRest bundleRest = this.bitstreamRestRepository.performBitstreamMove(context, bitstream, (Bundle)dsoList.get(0));
        context.commit();
        return bundleRest;
    }
}

