/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSynchronizeWithORCID", description="It can be used to verify if the user can synchronize with ORCID")
public class CanSynchronizeWithORCID
implements AuthorizationFeature {
    public static final String NAME = "canSynchronizeWithORCID";
    @Autowired
    private ItemService itemService;
    @Autowired
    private ConfigurationService configurationService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        EPerson ePerson = context.getCurrentUser();
        if (!(object instanceof ItemRest) || Objects.isNull(ePerson)) {
            return false;
        }
        String id = ((ItemRest)object).getId();
        Item item = (Item)this.itemService.find(context, UUID.fromString(id));
        return this.isOrcidSynchronizationEnabled() && this.isDspaceObjectOwner(ePerson, item);
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }

    private boolean isOrcidSynchronizationEnabled() {
        return this.configurationService.getBooleanProperty("orcid.synchronization-enabled", true);
    }

    private boolean isDspaceObjectOwner(EPerson eperson, Item item) {
        if (eperson == null) {
            return false;
        }
        List owners = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dspace.object.owner");
        Predicate<MetadataValue> checkOwner = v -> StringUtils.equals((CharSequence)v.getAuthority(), (CharSequence)eperson.getID().toString());
        return owners.stream().anyMatch(checkOwner);
    }
}

