/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.RootRestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.RootRest;
import org.dspace.app.rest.model.hateoas.RootResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;

@Component
public class RootHalLinkFactory
extends HalLinkFactory<RootResource, RootRestResourceController> {
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    protected void addLinks(RootResource halResource, Pageable page, LinkedList<Link> list) throws Exception {
        for (Link endpointLink : this.discoverableEndpointsService.getDiscoverableEndpoints()) {
            list.add(this.buildLink(endpointLink.getRel().value(), ((RootRest)halResource.getContent()).getDspaceServer() + endpointLink.getHref()));
        }
        list.add(this.buildLink(IanaLinkRelations.SELF.value(), (Object)((RootRestResourceController)this.getMethodOn(new Object[0])).listDefinedEndpoint(null)));
    }

    protected Class<RootRestResourceController> getControllerClass() {
        return RootRestResourceController.class;
    }

    protected Class<RootResource> getResourceClass() {
        return RootResource.class;
    }
}

