/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.SubscriptionParameterRest;
import org.dspace.app.rest.model.SubscriptionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.FrequencyType;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.subscriptions.SubscriptionEmailNotificationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.subscription")
public class SubscriptionRestRepository
extends DSpaceRestRepository<SubscriptionRest, Integer>
implements InitializingBean {
    @Autowired
    private ConverterService converter;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SubscribeService subscribeService;
    @Autowired
    private DSpaceObjectUtils dspaceObjectUtil;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private SubscriptionEmailNotificationService subscriptionEmailNotificationService;

    @PreAuthorize(value="hasPermission(#id, 'subscription', 'READ')")
    public SubscriptionRest findOne(Context context, Integer id) {
        Subscription subscription = null;
        try {
            subscription = this.subscribeService.findById(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return Objects.isNull(subscription) ? null : (SubscriptionRest)this.converter.toRest((Object)subscription, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<SubscriptionRest> findAll(Context context, Pageable pageable) {
        try {
            List subscriptionList = this.subscribeService.findAll(context, null, Integer.valueOf(Math.toIntExact(pageable.getPageSize())), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            Long total = this.subscribeService.countAll(context);
            return this.converter.toRestPage(subscriptionList, pageable, total.longValue(), this.utils.obtainProjection());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="findByEPerson")
    @PreAuthorize(value="hasPermission(#epersonId, 'EPERSON', 'READ')")
    public Page<SubscriptionRest> findSubscriptionsByEPerson(@Parameter(value="uuid", required=true) UUID epersonId, Pageable pageable) throws Exception {
        Long total = null;
        List subscriptions = null;
        try {
            Context context = this.obtainContext();
            EPerson ePerson = (EPerson)this.ePersonService.find(context, epersonId);
            subscriptions = this.subscribeService.findSubscriptionsByEPerson(context, ePerson, Integer.valueOf(Math.toIntExact(pageable.getPageSize())), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            total = this.subscribeService.countSubscriptionsByEPerson(context, ePerson);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return this.converter.toRestPage(subscriptions, pageable, total.longValue(), this.utils.obtainProjection());
    }

    @SearchRestMethod(name="findByEPersonAndDso")
    @PreAuthorize(value="hasPermission(#epersonId, 'EPERSON', 'READ')")
    public Page<SubscriptionRest> findByEPersonAndDso(@Parameter(value="eperson_id", required=true) UUID epersonId, @Parameter(value="resource", required=true) UUID dsoId, Pageable pageable) throws Exception {
        Long total = null;
        List subscriptions = null;
        try {
            Context context = this.obtainContext();
            DSpaceObject dSpaceObject = this.dspaceObjectUtil.findDSpaceObject(context, dsoId);
            EPerson ePerson = (EPerson)this.ePersonService.find(context, epersonId);
            subscriptions = this.subscribeService.findSubscriptionsByEPersonAndDso(context, ePerson, dSpaceObject, Integer.valueOf(Math.toIntExact(pageable.getPageSize())), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            total = this.subscribeService.countByEPersonAndDSO(context, ePerson, dSpaceObject);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return this.converter.toRestPage(subscriptions, pageable, total.longValue(), this.utils.obtainProjection());
    }

    @PreAuthorize(value="isAuthenticated()")
    protected SubscriptionRest createAndReturn(Context context) throws SQLException, AuthorizeException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        String epersonId = req.getParameter("eperson_id");
        String dsoId = req.getParameter("resource");
        if (StringUtils.isBlank((CharSequence)dsoId) || StringUtils.isBlank((CharSequence)epersonId)) {
            throw new UnprocessableEntityException("Both eperson than DSpaceObject uuids must be provieded!");
        }
        try {
            DSpaceObject dSpaceObject = this.dspaceObjectUtil.findDSpaceObject(context, UUID.fromString(dsoId));
            EPerson ePerson = (EPerson)this.ePersonService.findByIdOrLegacyId(context, epersonId);
            if (Objects.isNull(ePerson) || Objects.isNull(dSpaceObject)) {
                throw new DSpaceBadRequestException("Id of person or dspace object must represents reals ids");
            }
            if (!this.authorizeService.authorizeActionBoolean(context, ePerson, dSpaceObject, 0, true)) {
                throw new AuthorizeException("The user has not READ rights on this DSO");
            }
            if (!this.authorizeService.isAdmin(context) && !ePerson.equals((Object)context.getCurrentUser())) {
                throw new AuthorizeException("Only administrator can subscribe for other persons");
            }
            if (dSpaceObject.getType() == 4 || dSpaceObject.getType() == 3) {
                Subscription subscription = null;
                ServletInputStream input = req.getInputStream();
                SubscriptionRest subscriptionRest = (SubscriptionRest)new ObjectMapper().readValue((InputStream)input, SubscriptionRest.class);
                List subscriptionParameterList = subscriptionRest.getSubscriptionParameterList();
                if (CollectionUtils.isNotEmpty((Collection)subscriptionParameterList)) {
                    ArrayList subscriptionParameters = new ArrayList();
                    this.validateParameters(subscriptionRest, subscriptionParameterList, subscriptionParameters);
                    subscription = this.subscribeService.subscribe(context, ePerson, dSpaceObject, subscriptionParameters, subscriptionRest.getSubscriptionType());
                }
                context.commit();
                return (SubscriptionRest)this.converter.toRest(subscription, this.utils.obtainProjection());
            }
            throw new DSpaceBadRequestException("Currently subscription is supported only for Community and Collection");
        }
        catch (SQLException sqlException) {
            throw new SQLException(sqlException.getMessage(), sqlException);
        }
        catch (IOException ioException) {
            throw new UnprocessableEntityException("error parsing the body");
        }
    }

    private void validateParameters(SubscriptionRest subscriptionRest, List<SubscriptionParameterRest> subscriptionParameterList, List<SubscriptionParameter> subscriptionParameters) {
        for (SubscriptionParameterRest subscriptionParameterRest : subscriptionParameterList) {
            SubscriptionParameter subscriptionParameter = new SubscriptionParameter();
            String name = subscriptionParameterRest.getName();
            String value = subscriptionParameterRest.getValue();
            if (!StringUtils.equals((CharSequence)"frequency", (CharSequence)name) || !FrequencyType.isSupportedFrequencyType((String)value)) {
                throw new UnprocessableEntityException("Provided SubscriptionParameter name:" + name + " or value: " + value + " is not supported!");
            }
            subscriptionParameter.setName(name);
            subscriptionParameter.setValue(value);
            subscriptionParameters.add(subscriptionParameter);
        }
        String type = subscriptionRest.getSubscriptionType();
        if (!this.subscriptionEmailNotificationService.getSupportedSubscriptionTypes().contains(type)) {
            throw new UnprocessableEntityException("Provided subscriptionType:" + type + "  is not supported! Must be one of: " + this.subscriptionEmailNotificationService.getSupportedSubscriptionTypes());
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'subscription', 'WRITE')")
    protected SubscriptionRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws SQLException {
        SubscriptionRest subscriptionRest;
        try {
            subscriptionRest = (SubscriptionRest)new ObjectMapper().readValue(jsonNode.toString(), SubscriptionRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing subscription json: " + e.getMessage(), (Throwable)e);
        }
        Subscription subscription = this.subscribeService.findById(context, id.intValue());
        if (Objects.isNull(subscription)) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        if (id.equals(subscription.getID())) {
            ArrayList subscriptionParameters = new ArrayList();
            List subscriptionParameterList = subscriptionRest.getSubscriptionParameterList();
            this.validateParameters(subscriptionRest, subscriptionParameterList, subscriptionParameters);
            subscription = this.subscribeService.updateSubscription(context, id, subscriptionRest.getSubscriptionType(), subscriptionParameters);
            context.commit();
            return (SubscriptionRest)this.converter.toRest((Object)subscription, this.utils.obtainProjection());
        }
        throw new IllegalArgumentException("The id in the Json and the id in the url do not match: " + id + ", " + subscription.getID());
    }

    @PreAuthorize(value="hasPermission(#id, 'subscription', 'DELETE')")
    protected void delete(Context context, Integer id) {
        try {
            Subscription subscription = this.subscribeService.findById(context, id.intValue());
            if (Objects.isNull(subscription)) {
                throw new ResourceNotFoundException("core.subscription with id: " + id + " not found");
            }
            this.subscribeService.deleteSubscription(context, subscription);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Subscription with id = " + id, e);
        }
    }

    public Class<SubscriptionRest> getDomainClass() {
        return SubscriptionRest.class;
    }

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(Link.of((String)"/api/core/subscriptions/search", (String)"subscriptions-search")));
    }
}

