/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Component;

@Component
public class CustomLogoutHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomLogoutHandler.class);
    @Autowired
    private RestAuthenticationService restAuthenticationService;

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        try {
            Context context = ContextUtil.obtainContext((HttpServletRequest)httpServletRequest);
            this.restAuthenticationService.invalidateAuthenticationData(httpServletRequest, httpServletResponse, context);
            context.complete();
        }
        catch (Exception e) {
            log.error("Unable to logout", (Throwable)e);
        }
    }
}

