/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class VersionRestPatchPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(VersionRestPatchPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private VersioningService versioningService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.ADMIN.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"version")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getHttpServletRequest());
        try {
            if (targetId instanceof UUID) {
                return false;
            }
            int versionId = Integer.parseInt(targetId.toString());
            Version version = this.versioningService.getVersion(context, versionId);
            if (version == null) {
                return true;
            }
            if (!this.authorizeService.isAdmin(context, (DSpaceObject)version.getItem()) && !this.authorizeService.isAdmin(context)) {
                return false;
            }
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)version.getItem(), restPermission.getDspaceApiActionId())) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

