/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataAccessCondition;
import org.dspace.app.rest.submit.AbstractProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.factory.PatchOperationFactory;
import org.dspace.app.rest.submit.factory.impl.PatchOperation;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class AccessConditionStep
extends AbstractProcessingStep {
    public DataAccessCondition getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        DataAccessCondition accessCondition = new DataAccessCondition();
        accessCondition.setDiscoverable(Boolean.valueOf(obj.getItem().isDiscoverable()));
        accessCondition.setAccessConditions(this.getAccessConditionList(obj.getItem()));
        return accessCondition;
    }

    public void doPatchProcessing(Context context, HttpServletRequest currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        String instance = "";
        if (op.getPath().contains("discoverable")) {
            instance = "discoverable";
        } else if (op.getPath().contains("accessConditions")) {
            instance = "accessConditions";
        }
        if (StringUtils.isBlank((String)instance)) {
            throw new UnprocessableEntityException("The path " + op.getPath() + " is not supported by the operation " + op.getOp());
        }
        currentRequest.setAttribute("accessConditionSectionId", (Object)stepConf.getId());
        PatchOperation patchOperation = new PatchOperationFactory().instanceOf(instance, op.getOp());
        patchOperation.perform(context, currentRequest, source, op);
    }

    private List<AccessConditionDTO> getAccessConditionList(Item item) {
        ArrayList<AccessConditionDTO> accessConditions = new ArrayList<AccessConditionDTO>();
        for (ResourcePolicy rp : item.getResourcePolicies()) {
            if (!ResourcePolicy.TYPE_CUSTOM.equals(rp.getRpType())) continue;
            AccessConditionDTO accessConditionDTO = this.createAccessConditionFromResourcePolicy(rp);
            accessConditions.add(accessConditionDTO);
        }
        return accessConditions;
    }

    private AccessConditionDTO createAccessConditionFromResourcePolicy(ResourcePolicy rp) {
        AccessConditionDTO accessCondition = new AccessConditionDTO();
        accessCondition.setId(rp.getID());
        accessCondition.setName(rp.getRpName());
        accessCondition.setDescription(rp.getRpDescription());
        accessCondition.setStartDate(rp.getStartDate());
        accessCondition.setEndDate(rp.getEndDate());
        return accessCondition;
    }
}

