/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.EntityTypeResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.EntityType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/entitytypes"})
public class EntityTypeLabelRestController {
    protected final EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    @Autowired
    protected ConverterService converter;
    @Autowired
    protected Utils utils;

    @GetMapping(value={"/label/{entity-type-label}"})
    public EntityTypeResource get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="entity-type-label") String label) {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        try {
            EntityType entityType = this.entityTypeService.findByEntityType(context, label);
            if (entityType == null) {
                throw new ResourceNotFoundException("There was no entityType found with label: " + label);
            }
            return (EntityTypeResource)this.converter.toResource((RestModel)this.converter.toRest((Object)entityType, this.utils.obtainProjection()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

