/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.converter.SubmissionDefinitionConverter;
import org.dspace.app.rest.converter.SubmissionSectionConverter;
import org.dspace.app.rest.model.AInprogressSubmissionRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SubmissionDefinitionRest;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AInprogressItemConverter<T extends InProgressSubmission<ID>, R extends AInprogressSubmissionRest<ID>, ID extends Serializable>
implements IndexableObjectConverter<T, R> {
    private static final Logger log = LogManager.getLogger(AInprogressItemConverter.class);
    @Autowired
    private EPersonConverter epersonConverter;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private CollectionConverter collectionConverter;
    protected SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();
    @Autowired
    private SubmissionDefinitionConverter submissionDefinitionConverter;
    @Autowired
    private SubmissionSectionConverter submissionSectionConverter;
    @Autowired
    SubmissionService submissionService;

    protected void fillFromModel(T obj, R witem) {
        Collection collection = obj.getCollection();
        Item item = obj.getItem();
        EPerson submitter = null;
        try {
            submitter = obj.getSubmitter();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        witem.setId(obj.getID());
        witem.setCollection(collection != null ? (CollectionRest)this.collectionConverter.convert((Object)collection) : null);
        witem.setItem((ItemRest)this.itemConverter.convert((Object)item));
        witem.setSubmitter((EPersonRest)this.epersonConverter.convert((Object)submitter));
        if (collection != null) {
            SubmissionDefinitionRest def = (SubmissionDefinitionRest)this.submissionDefinitionConverter.convert((Object)this.submissionConfigReader.getSubmissionConfigByCollection(collection.getHandle()));
            witem.setSubmissionDefinition(def);
            for (SubmissionSectionRest sections : def.getPanels()) {
                SubmissionStepConfig stepConfig = this.submissionSectionConverter.toModel(sections);
                ClassLoader loader = this.getClass().getClassLoader();
                try {
                    Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                    Object stepInstance = stepClass.newInstance();
                    if (stepInstance instanceof AbstractRestProcessingStep) {
                        AbstractRestProcessingStep stepProcessing = (AbstractRestProcessingStep)stepClass.newInstance();
                        for (ErrorRest error : stepProcessing.validate(this.submissionService, obj, stepConfig)) {
                            this.addError(witem.getErrors(), error);
                        }
                        witem.getSections().put((String)((Object)sections.getId()), stepProcessing.getData(this.submissionService, obj, stepConfig));
                        continue;
                    }
                    log.warn("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not extend the class org.dspace.app.rest.submit.AbstractRestProcessingStep! Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
                }
                catch (Exception e) {
                    log.error("An error occurred during the unmarshal of the data for the section " + (String)((Object)sections.getId()) + " - reported error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void addError(List<ErrorRest> errors, ErrorRest toAdd) {
        boolean found = false;
        String i18nKey = toAdd.getMessage();
        if (StringUtils.isNotBlank((CharSequence)i18nKey)) {
            for (ErrorRest error : errors) {
                if (!i18nKey.equals(error.getMessage())) continue;
                error.getPaths().addAll(toAdd.getPaths());
                found = true;
                break;
            }
        }
        if (!found) {
            errors.add(toAdd);
        }
    }
}

