/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.converter.BitstreamFormatConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CheckSumRest;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitstreamConverter
extends DSpaceObjectConverter<Bitstream, BitstreamRest> {
    @Autowired(required=true)
    BitstreamFormatConverter bfConverter;

    public Bitstream toModel(BitstreamRest obj) {
        return (Bitstream)super.toModel((DSpaceObjectRest)obj);
    }

    public BitstreamRest fromModel(Bitstream obj) {
        BitstreamRest b = (BitstreamRest)super.fromModel((DSpaceObject)obj);
        List bundles = null;
        try {
            bundles = obj.getBundles();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (bundles != null && bundles.size() > 0) {
            b.setBundleName(((Bundle)bundles.get(0)).getName());
        }
        CheckSumRest checksum = new CheckSumRest();
        checksum.setCheckSumAlgorithm(obj.getChecksumAlgorithm());
        checksum.setValue(obj.getChecksum());
        b.setCheckSum(checksum);
        BitstreamFormatRest format = null;
        try {
            format = this.bfConverter.fromModel(obj.getFormat(null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        b.setFormat(format);
        b.setSizeBytes(Long.valueOf(obj.getSizeBytes()));
        return b;
    }

    protected BitstreamRest newInstance() {
        return new BitstreamRest();
    }

    protected Class<Bitstream> getModelClass() {
        return Bitstream.class;
    }
}

