/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.converter.ResourcePolicyConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectionConverter
extends DSpaceObjectConverter<Collection, CollectionRest>
implements IndexableObjectConverter<Collection, CollectionRest> {
    private static final Logger log = LogManager.getLogger(CollectionConverter.class);
    @Autowired
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ResourcePolicyConverter resourcePolicyConverter;

    public Collection toModel(CollectionRest obj) {
        return (Collection)super.toModel((DSpaceObjectRest)obj);
    }

    public CollectionRest fromModel(Collection obj) {
        CollectionRest col = (CollectionRest)super.fromModel((DSpaceObject)obj);
        Bitstream logo = obj.getLogo();
        if (logo != null) {
            col.setLogo((BitstreamRest)this.bitstreamConverter.convert((Object)logo));
        }
        col.setDefaultAccessConditions(this.getDefaultBitstreamPoliciesForCollection(obj.getID()));
        return col;
    }

    private List<ResourcePolicyRest> getDefaultBitstreamPoliciesForCollection(UUID uuid) {
        Context context = null;
        Request currentRequest = this.requestService.getCurrentRequest();
        if (currentRequest != null) {
            HttpServletRequest request = currentRequest.getHttpServletRequest();
            context = ContextUtil.obtainContext((ServletRequest)request);
        } else {
            context = new Context();
        }
        Collection collection = null;
        List defaultCollectionPolicies = null;
        try {
            collection = (Collection)this.collectionService.find(context, uuid);
            defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(context, (DSpaceObject)collection, 9);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList<ResourcePolicyRest> results = new ArrayList<ResourcePolicyRest>();
        for (ResourcePolicy pp : defaultCollectionPolicies) {
            ResourcePolicyRest accessCondition = (ResourcePolicyRest)this.resourcePolicyConverter.convert((Object)pp);
            if (accessCondition == null) continue;
            results.add(accessCondition);
        }
        return results;
    }

    protected CollectionRest newInstance() {
        return new CollectionRest();
    }

    protected Class<Collection> getModelClass() {
        return Collection.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo instanceof Collection;
    }
}

