/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.discovery.IndexableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommunityConverter
extends DSpaceObjectConverter<Community, CommunityRest>
implements IndexableObjectConverter<Community, CommunityRest> {
    @Autowired
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private CollectionConverter collectionConverter;

    public Community toModel(CommunityRest obj) {
        return (Community)super.toModel((DSpaceObjectRest)obj);
    }

    public CommunityRest fromModel(Community obj) {
        CommunityRest com = (CommunityRest)super.fromModel((DSpaceObject)obj);
        Bitstream logo = obj.getLogo();
        if (logo != null) {
            com.setLogo((BitstreamRest)this.bitstreamConverter.convert((Object)logo));
        }
        List collections = obj.getCollections();
        ArrayList<CollectionRest> collectionsRest = new ArrayList<CollectionRest>();
        if (collections != null) {
            for (Collection col : collections) {
                CollectionRest colrest = this.collectionConverter.fromModel(col);
                collectionsRest.add(colrest);
            }
        }
        com.setCollections(collectionsRest);
        List subCommunities = obj.getSubcommunities();
        ArrayList<CommunityRest> communityRest = new ArrayList<CommunityRest>();
        if (subCommunities != null) {
            for (Community scom : subCommunities) {
                CommunityRest scomrest = this.fromModel(scom);
                communityRest.add(scomrest);
            }
        }
        com.setSubCommunities(communityRest);
        return com;
    }

    protected CommunityRest newInstance() {
        return new CommunityRest();
    }

    protected Class<Community> getModelClass() {
        return Community.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo instanceof Community;
    }
}

