/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.GroupConverter;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EPersonConverter
extends DSpaceObjectConverter<EPerson, EPersonRest> {
    @Autowired(required=true)
    private GroupConverter epersonGroupConverter;
    @Autowired(required=true)
    private GroupService groupService;
    private static final Logger log = LogManager.getLogger(EPersonConverter.class);

    public EPersonRest fromModel(EPerson obj) {
        EPersonRest eperson = (EPersonRest)super.fromModel((DSpaceObject)obj);
        eperson.setLastActive(obj.getLastActive());
        eperson.setNetid(obj.getNetid());
        eperson.setCanLogIn(obj.canLogIn());
        eperson.setRequireCertificate(obj.getRequireCertificate());
        eperson.setSelfRegistered(obj.getSelfRegistered());
        eperson.setEmail(obj.getEmail());
        return eperson;
    }

    public EPersonRest fromModelWithGroups(Context context, EPerson ePerson) throws SQLException {
        EPersonRest eperson = this.fromModel(ePerson);
        ArrayList<GroupRest> groups = new ArrayList<GroupRest>();
        for (Group g : this.groupService.allMemberGroups(context, ePerson)) {
            groups.add((GroupRest)this.epersonGroupConverter.convert((Object)g));
        }
        eperson.setGroups(groups);
        return eperson;
    }

    public EPerson toModel(EPersonRest obj) {
        return null;
    }

    protected EPersonRest newInstance() {
        return new EPersonRest();
    }

    protected Class<EPerson> getModelClass() {
        return EPerson.class;
    }
}

