/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.model.SubmissionVisibilityRest;
import org.dspace.app.rest.model.VisibilityEnum;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.springframework.stereotype.Component;

@Component
public class SubmissionSectionConverter
implements DSpaceConverter<SubmissionStepConfig, SubmissionSectionRest> {
    private static final Logger log = LogManager.getLogger(SubmissionSectionConverter.class);
    private SubmissionConfigReader submissionConfigReader;

    public SubmissionSectionRest fromModel(SubmissionStepConfig step) {
        SubmissionSectionRest sp = new SubmissionSectionRest();
        sp.setMandatory(step.isMandatory());
        sp.setHeader(step.getHeading());
        sp.setSectionType(step.getType());
        sp.setId((Serializable)((Object)step.getId()));
        sp.setVisibility(new SubmissionVisibilityRest(VisibilityEnum.fromString((String)step.getVisibility()), VisibilityEnum.fromString((String)step.getVisibilityOutside())));
        return sp;
    }

    public SubmissionStepConfig toModel(SubmissionSectionRest obj) {
        SubmissionStepConfig step;
        try {
            step = this.getSubmissionConfigReader().getStepConfig((String)((Object)obj.getId()));
        }
        catch (SubmissionConfigReaderException e) {
            throw new RuntimeException(e);
        }
        return step;
    }

    public SubmissionConfigReader getSubmissionConfigReader() throws SubmissionConfigReaderException {
        if (this.submissionConfigReader == null) {
            this.submissionConfigReader = new SubmissionConfigReader();
        }
        return this.submissionConfigReader;
    }
}

