/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.EmbeddedPageHeader;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;

public abstract class HALResource<T>
extends Resource<T> {
    protected final Map<String, Object> embedded = new HashMap();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonUnwrapped
    private EmbeddedPageHeader pageHeader;

    public HALResource(T content) {
        super(content, new Link[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="_embedded")
    public Map<String, Object> getEmbeddedResources() {
        return this.embedded;
    }

    public void embedResource(String relationship, HALResource resource) {
        this.embedded.put(relationship, resource);
    }

    public void embedResource(String relationship, EmbeddedPage embeddedPage) {
        this.embedded.put(relationship, embeddedPage);
    }

    public void embedResource(String relationship, Collection<? extends HALResource> resource) {
        this.embedded.put(relationship, resource);
    }

    public void setPageHeader(EmbeddedPageHeader page) {
        this.pageHeader = page;
    }
}

