/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.converter.BitstreamFormatConverter;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.model.hateoas.BitstreamFormatResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component(value="core.bitstreamformat")
public class BitstreamFormatRestRepository
extends DSpaceRestRepository<BitstreamFormatRest, Integer> {
    @Autowired
    BitstreamFormatService bfs;
    @Autowired
    BitstreamFormatConverter converter;

    public BitstreamFormatRestRepository() {
        System.out.println("Repository initialized by Spring");
    }

    public BitstreamFormatRest findOne(Context context, Integer id) {
        BitstreamFormat bit = null;
        try {
            bit = (BitstreamFormat)this.bfs.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        return this.converter.fromModel(bit);
    }

    public Page<BitstreamFormatRest> findAll(Context context, Pageable pageable) {
        List bit = null;
        try {
            bit = this.bfs.findAll(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(bit, pageable).map((Converter)this.converter);
        return page;
    }

    public Class<BitstreamFormatRest> getDomainClass() {
        return BitstreamFormatRest.class;
    }

    public BitstreamFormatResource wrapResource(BitstreamFormatRest bs, String ... rels) {
        return new BitstreamFormatResource(bs, this.utils, rels);
    }
}

