/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import org.dspace.app.rest.converter.BrowseIndexConverter;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.model.hateoas.BrowseIndexResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component(value="discover.browse")
public class BrowseIndexRestRepository
extends DSpaceRestRepository<BrowseIndexRest, String> {
    @Autowired
    BrowseIndexConverter converter;

    public BrowseIndexRest findOne(Context context, String name) {
        BrowseIndex bix;
        BrowseIndexRest bi = null;
        try {
            bix = BrowseIndex.getBrowseIndex((String)name);
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bix != null) {
            bi = (BrowseIndexRest)this.converter.convert((Object)bix);
        }
        return bi;
    }

    public Page<BrowseIndexRest> findAll(Context context, Pageable pageable) {
        Object it = null;
        ArrayList<BrowseIndex> indexesList = new ArrayList<BrowseIndex>();
        int total = 0;
        try {
            BrowseIndex[] indexes = BrowseIndex.getBrowseIndices();
            total = indexes.length;
            for (BrowseIndex bix : indexes) {
                indexesList.add(bix);
            }
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(indexesList, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    public Class<BrowseIndexRest> getDomainClass() {
        return BrowseIndexRest.class;
    }

    public BrowseIndexResource wrapResource(BrowseIndexRest bix, String ... rels) {
        return new BrowseIndexResource(bix, this.utils, rels);
    }
}

