/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.hateoas.ItemResource;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.ItemRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.ScopeResolver;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component(value="discover.browse.items")
public class BrowseItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository<ItemRest> {
    @Autowired
    ItemConverter converter;
    @Autowired
    ItemRestRepository itemRestRepository;
    @Autowired
    ScopeResolver scopeResolver;

    public Page<ItemRest> listBrowseItems(HttpServletRequest request, String browseName, Pageable pageable, String projection) throws BrowseException, SQLException {
        String scope = null;
        String filterValue = null;
        String filterAuthority = null;
        String startsWith = null;
        if (request != null) {
            scope = request.getParameter("scope");
            filterValue = request.getParameter("filterValue");
            filterAuthority = request.getParameter("filterAuthority");
            startsWith = request.getParameter("startsWith");
        }
        Context context = this.obtainContext();
        BrowseEngine be = new BrowseEngine(context);
        BrowserScope bs = new BrowserScope(context);
        IndexableObject scopeObj = this.scopeResolver.resolveScope(context, scope);
        BrowseIndex bi = null;
        if (StringUtils.isNotEmpty((CharSequence)browseName)) {
            bi = BrowseIndex.getBrowseIndex((String)browseName);
        }
        if (bi == null) {
            throw new IllegalArgumentException("Unknown browse index");
        }
        if (!bi.isItemIndex() && filterAuthority == null && filterValue == null) {
            throw new IllegalStateException("The requested browse doesn't provide direct access to items you must specify a filter");
        }
        if (!(bi.isMetadataIndex() || filterAuthority == null && filterValue == null)) {
            throw new IllegalStateException("The requested browse doesn't support filtering");
        }
        bs.setBrowseIndex(bi);
        Sort sort = null;
        if (pageable != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            for (Sort.Order order : sort) {
                bs.setOrder(order.getDirection().name());
                String sortBy = !StringUtils.equals((CharSequence)"default", (CharSequence)order.getProperty()) ? order.getProperty() : bi.getDefaultOrder();
                try {
                    SortOption so = SortOption.getSortOption((String)sortBy);
                    if (so == null) continue;
                    bs.setSortBy(so.getNumber());
                }
                catch (SortException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        if (filterValue != null || filterAuthority != null) {
            bs.setFilterValue(filterValue);
            bs.setAuthorityValue(filterAuthority);
            bs.setBrowseLevel(1);
        }
        bs.setStartsWith(startsWith);
        if (pageable != null) {
            bs.setOffset(pageable.getOffset());
            bs.setResultsPerPage(pageable.getPageSize());
        }
        if (scopeObj != null) {
            bs.setBrowseContainer(scopeObj);
        }
        if (bi != null && bi.isMetadataIndex() && bs.isSecondLevel() && bs.getSortBy() <= 0) {
            bs.setSortBy(1);
        }
        BrowseInfo binfo = be.browse(bs);
        PageRequest pageResultInfo = new PageRequest((binfo.getStart() - 1) / binfo.getResultsPerPage(), binfo.getResultsPerPage());
        ArrayList<Item> tmpResult = new ArrayList<Item>();
        for (IndexableObject bb : binfo.getBrowseItemResults()) {
            tmpResult.add((Item)bb);
        }
        Page page = new PageImpl(tmpResult, (Pageable)pageResultInfo, (long)binfo.getTotal()).map((Converter)this.converter);
        return page;
    }

    public ItemResource wrapResource(ItemRest item, String ... rels) {
        return this.itemRestRepository.wrapResource(item, rels);
    }

    public boolean isEmbeddableRelation(Object data, String name) {
        BrowseIndexRest bir = (BrowseIndexRest)data;
        return !bir.isMetadataBrowse() && "items".equals(name);
    }
}

