/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.hateoas.CollectionResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.app.rest.utils.CollectionRestEqualityUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.collection")
public class CollectionRestRepository
extends DSpaceObjectRestRepository<Collection, CollectionRest> {
    private final CollectionService cs;
    @Autowired
    CommunityService communityService;
    @Autowired
    CollectionConverter converter;
    @Autowired
    MetadataConverter metadataConverter;
    @Autowired
    CollectionRestEqualityUtils collectionRestEqualityUtils;

    public CollectionRestRepository(CollectionService dsoService, CollectionConverter dsoConverter) {
        super((DSpaceObjectService)dsoService, (DSpaceObjectConverter)dsoConverter, (DSpaceObjectPatch)new /* Unavailable Anonymous Inner Class!! */);
        this.cs = dsoService;
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'READ')")
    public CollectionRest findOne(Context context, UUID id) {
        Collection collection = null;
        try {
            collection = (Collection)this.cs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (collection == null) {
            return null;
        }
        return (CollectionRest)this.dsoConverter.fromModel((DSpaceObject)collection);
    }

    public Page<CollectionRest> findAll(Context context, Pageable pageable) {
        List it = null;
        ArrayList<Collection> collections = new ArrayList<Collection>();
        int total = 0;
        try {
            total = this.cs.countTotal(context);
            it = this.cs.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
            for (Collection c : it) {
                collections.add(c);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = new PageImpl(collections, pageable, (long)total).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="findAuthorizedByCommunity")
    public Page<CollectionRest> findAuthorizedByCommunity(@Parameter(value="uuid", required=true) UUID communityUuid, Pageable pageable) {
        Context context = this.obtainContext();
        List it = null;
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            Community com = (Community)this.communityService.find(context, communityUuid);
            if (com == null) {
                throw new ResourceNotFoundException("core.community with id: " + communityUuid + " not found");
            }
            it = this.cs.findAuthorized(context, com, 3);
            for (Collection c : it) {
                collections.add(c);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(collections, pageable).map((Converter)this.dsoConverter);
        return page;
    }

    @SearchRestMethod(name="findAuthorized")
    public Page<CollectionRest> findAuthorized(Pageable pageable) {
        Context context = this.obtainContext();
        List it = null;
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            it = this.cs.findAuthorizedOptimized(context, 3);
            for (Collection c : it) {
                collections.add(c);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(collections, pageable).map((Converter)this.dsoConverter);
        return page;
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    public Class<CollectionRest> getDomainClass() {
        return CollectionRest.class;
    }

    public CollectionResource wrapResource(CollectionRest collection, String ... rels) {
        return new CollectionResource(collection, this.utils, rels);
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected CollectionRest createAndReturn(Context context) throws AuthorizeException {
        Collection collection;
        CollectionRest collectionRest;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            collectionRest = (CollectionRest)mapper.readValue((InputStream)input, CollectionRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body: " + e1.toString());
        }
        String parentCommunityString = req.getParameter("parent");
        try {
            Community parent = null;
            if (StringUtils.isNotBlank((CharSequence)parentCommunityString)) {
                UUID parentCommunityUuid = UUIDUtils.fromString((String)parentCommunityString);
                if (parentCommunityUuid == null) {
                    throw new BadRequestException("The given parent was invalid: " + parentCommunityString);
                }
                parent = (Community)this.communityService.find(context, parentCommunityUuid);
                if (parent == null) {
                    throw new UnprocessableEntityException("Parent community for id: " + parentCommunityUuid + " not found");
                }
            } else {
                throw new BadRequestException("The parent parameter cannot be left empty,collections require a parent community.");
            }
            collection = this.cs.create(context, parent);
            this.cs.update(context, (DSpaceObject)collection);
            this.metadataConverter.setMetadata(context, (DSpaceObject)collection, collectionRest.getMetadata());
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to create new Collection under parent Community " + parentCommunityString, e);
        }
        return (CollectionRest)this.converter.convert((Object)collection);
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'WRITE')")
    protected CollectionRest put(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        CollectionRest collectionRest;
        try {
            collectionRest = (CollectionRest)new ObjectMapper().readValue(jsonNode.toString(), CollectionRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing collection json: " + e.getMessage());
        }
        Collection collection = (Collection)this.cs.find(context, id);
        if (collection == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        CollectionRest originalCollectionRest = this.converter.fromModel(collection);
        if (!this.collectionRestEqualityUtils.isCollectionRestEqualWithoutMetadata(originalCollectionRest, collectionRest)) {
            throw new IllegalArgumentException("The UUID in the Json and the UUID in the url do not match: " + id + ", " + collectionRest.getId());
        }
        this.metadataConverter.setMetadata(context, (DSpaceObject)collection, collectionRest.getMetadata());
        return this.converter.fromModel(collection);
    }

    @PreAuthorize(value="hasPermission(#id, 'COLLECTION', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Collection collection = null;
        try {
            collection = (Collection)this.cs.find(context, id);
            if (collection == null) {
                throw new ResourceNotFoundException("core.collection with id: " + id + " not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to find Collection with id = " + id, e);
        }
        try {
            this.cs.delete(context, (DSpaceObject)collection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to delete Collection with id = " + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete collection because the logo couldn't be deleted", e);
        }
    }
}

