/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.MetadataConverter;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.DSpaceObjectPatch;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;

public abstract class DSpaceObjectRestRepository<M extends DSpaceObject, R extends DSpaceObjectRest>
extends DSpaceRestRepository<R, UUID> {
    final DSpaceObjectService<M> dsoService;
    final DSpaceObjectPatch<R> dsoPatch;
    final DSpaceObjectConverter<M, R> dsoConverter;
    @Autowired
    MetadataConverter metadataConverter;

    DSpaceObjectRestRepository(DSpaceObjectService<M> dsoService, DSpaceObjectConverter<M, R> dsoConverter, DSpaceObjectPatch<R> dsoPatch) {
        this.dsoService = dsoService;
        this.dsoPatch = dsoPatch;
        this.dsoConverter = dsoConverter;
    }

    protected void patchDSpaceObject(String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, ResourceNotFoundException, SQLException, UnprocessableEntityException {
        DSpaceObject dso = this.dsoService.find(this.obtainContext(), id);
        if (dso == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        DSpaceObjectRest dsoRest = this.dsoPatch.patch((DSpaceObjectRest)this.findOne((Serializable)id), patch.getOperations());
        this.updateDSpaceObject(dso, dsoRest);
    }

    protected void updateDSpaceObject(M dso, R dsoRest) throws AuthorizeException, SQLException {
        DSpaceObjectRest origDsoRest = this.dsoConverter.fromModel(dso);
        if (!origDsoRest.getMetadata().equals((Object)dsoRest.getMetadata())) {
            this.metadataConverter.setMetadata(this.obtainContext(), dso, dsoRest.getMetadata());
        }
    }
}

