/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.multipart.MultipartFile;

public abstract class DSpaceRestRepository<T extends RestAddressableModel, ID extends Serializable>
extends AbstractDSpaceRestRepository
implements PagingAndSortingRepository<T, ID> {
    private static final Logger log = LogManager.getLogger(DSpaceRestRepository.class);
    @Autowired
    private DSpaceRestRepository<T, ID> thisRepository;
    @Autowired
    private MetadataFieldService metadataFieldService;

    public <S extends T> S save(S entity) {
        Context context = null;
        try {
            context = this.obtainContext();
            RestAddressableModel res = this.save(context, entity);
            context.commit();
            return (S)res;
        }
        catch (AuthorizeException ex) {
            throw new RESTAuthorizationException(ex);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected <S extends T> S save(Context context, S entity) throws AuthorizeException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return null;
    }

    public T findOne(ID id) {
        Context context = this.obtainContext();
        return (T)this.thisRepository.findOne(context, id);
    }

    public abstract T findOne(Context var1, ID var2);

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public final Iterable<T> findAll() {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public long count() {
        return 0L;
    }

    public void delete(ID id) {
        Context context = this.obtainContext();
        try {
            this.thisRepository.delete(context, id);
            context.commit();
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected void delete(Context context, ID id) throws AuthorizeException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public void delete(T entity) {
    }

    public void delete(Iterable<? extends T> entities) {
    }

    public void deleteAll() {
    }

    public final Iterable<T> findAll(Sort sort) {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public Page<T> findAll(Pageable pageable) {
        Context context = this.obtainContext();
        return this.thisRepository.findAll(context, pageable);
    }

    public abstract Page<T> findAll(Context var1, Pageable var2);

    public abstract Class<T> getDomainClass();

    public abstract DSpaceResource<T> wrapResource(T var1, String ... var2);

    public T createAndReturn(List<String> list) {
        Context context = null;
        try {
            context = this.obtainContext();
            RestAddressableModel entity = this.thisRepository.createAndReturn(context, list);
            context.commit();
            return (T)entity;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public T createAndReturn() {
        Context context = null;
        try {
            context = this.obtainContext();
            RestAddressableModel entity = this.thisRepository.createAndReturn(context);
            context.commit();
            return (T)entity;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected T createAndReturn(Context context, List<String> list) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    protected T createAndReturn(Context context) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public T upload(HttpServletRequest request, String apiCategory, String model, ID id, MultipartFile file) throws Exception {
        throw new RuntimeException("No implementation found; Method not allowed!");
    }

    public T patch(HttpServletRequest request, String apiCategory, String model, ID id, Patch patch) throws HttpRequestMethodNotSupportedException, UnprocessableEntityException, PatchBadRequestException {
        Context context = this.obtainContext();
        try {
            this.thisRepository.patch(context, request, apiCategory, model, id, patch);
            context.commit();
        }
        catch (AuthorizeException ae) {
            throw new RESTAuthorizationException(ae);
        }
        catch (SQLException | DCInputsReaderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (T)this.findOne(id);
    }

    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, ID id, Patch patch) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException, DCInputsReaderException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }

    public T action(HttpServletRequest request, ID id) throws SQLException, IOException {
        Context context = this.obtainContext();
        RestAddressableModel entity = this.action(context, request, id);
        context.commit();
        return (T)entity;
    }

    protected T action(Context context, HttpServletRequest request, ID id) throws SQLException, IOException {
        throw new RuntimeException("No implementation found; Method not allowed!");
    }

    public Iterable<T> upload(HttpServletRequest request, MultipartFile uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        Context context = this.obtainContext();
        Iterable entity = this.upload(context, request, uploadfile);
        context.commit();
        return entity;
    }

    protected Iterable<T> upload(Context context, HttpServletRequest request, MultipartFile uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public T put(HttpServletRequest request, String apiCategory, String model, ID uuid, JsonNode jsonNode) {
        Context context = this.obtainContext();
        try {
            this.thisRepository.put(context, request, apiCategory, model, uuid, jsonNode);
            context.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to update DSpace object " + model + " with id=" + uuid, e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException("Unable to perform PUT request as the current user does not have sufficient rights", e);
        }
        return (T)this.findOne(uuid);
    }

    public T put(HttpServletRequest request, String apiCategory, String model, ID id, List<String> stringList) {
        Context context = this.obtainContext();
        try {
            this.thisRepository.put(context, request, apiCategory, model, id, stringList);
            context.commit();
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (T)this.findOne(id);
    }

    protected T put(Context context, HttpServletRequest request, String apiCategory, String model, ID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }

    protected T put(Context context, HttpServletRequest request, String apiCategory, String model, ID id, List<String> stringList) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }
}

