/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.converter.EntityTypeConverter;
import org.dspace.app.rest.model.EntityTypeRest;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.EntityTypeResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="core.entitytype")
public class EntityTypeRestRepository
extends DSpaceRestRepository<EntityTypeRest, Integer> {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private EntityTypeConverter entityTypeConverter;

    public EntityTypeRest findOne(Context context, Integer integer) {
        try {
            EntityType entityType = (EntityType)this.entityTypeService.find(context, integer.intValue());
            if (entityType == null) {
                throw new ResourceNotFoundException("The entityType for ID: " + integer + " could not be found");
            }
            return this.entityTypeConverter.fromModel(entityType);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<EntityTypeRest> findAll(Context context, Pageable pageable) {
        List entityTypeList = null;
        try {
            entityTypeList = this.entityTypeService.findAll(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Page page = this.utils.getPage(entityTypeList, pageable).map((Converter)this.entityTypeConverter);
        return page;
    }

    public Class<EntityTypeRest> getDomainClass() {
        return EntityTypeRest.class;
    }

    public DSpaceResource<EntityTypeRest> wrapResource(EntityTypeRest model, String ... rels) {
        return new EntityTypeResource(model, this.utils, rels);
    }
}

