/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.dspace.app.rest.converter.FilteredDiscoveryPageConverter;
import org.dspace.app.rest.model.FilteredDiscoveryPageRest;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.FilteredDiscoveryPageResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.virtual.EntityTypeToFilterQueryService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component(value="config.filtered-discovery-page")
public class FilteredDiscoveryPageRestRepository
extends DSpaceRestRepository<FilteredDiscoveryPageRest, String> {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private FilteredDiscoveryPageConverter filteredDiscoveryPageConverter;
    @Autowired
    private EntityTypeToFilterQueryService entityTypeToFilterQueryService;

    public FilteredDiscoveryPageRest findOne(Context context, String string) {
        try {
            return this.filteredDiscoveryPageConverter.fromModel(this.entityTypeService.findByEntityType(context, string));
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<FilteredDiscoveryPageRest> findAll(Context context, Pageable pageable) {
        List entityTypeList = null;
        try {
            entityTypeList = this.entityTypeService.findAll(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        LinkedList<EntityType> resultingList = new LinkedList<EntityType>();
        for (EntityType entityType : entityTypeList) {
            if (!this.entityTypeToFilterQueryService.hasKey(entityType.getLabel())) continue;
            resultingList.add(entityType);
        }
        Page page = this.utils.getPage(resultingList, pageable).map((Converter)this.filteredDiscoveryPageConverter);
        return page;
    }

    public Class<FilteredDiscoveryPageRest> getDomainClass() {
        return FilteredDiscoveryPageRest.class;
    }

    public DSpaceResource<FilteredDiscoveryPageRest> wrapResource(FilteredDiscoveryPageRest model, String ... rels) {
        return new FilteredDiscoveryPageResource(model, this.utils, rels);
    }
}

