/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.LicenseRest;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.LicenseResource;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.core.service.LicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.collection.license")
public class LicenseRestLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository<LicenseRest> {
    @Autowired
    CollectionService collectionService;
    @Autowired
    LicenseService licenseService;

    public HALResource wrapResource(LicenseRest model, String ... rels) {
        return new LicenseResource(model);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public LicenseRest getLicenseCollection(HttpServletRequest request, UUID uuid, Pageable pageable, String projection) throws Exception {
        Context context = this.obtainContext();
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        LicenseRest licenseRest = new LicenseRest();
        String text = collection.getLicenseCollection();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            licenseRest.setCustom(true);
            licenseRest.setText(text);
        } else {
            licenseRest.setText(this.licenseService.getDefaultSubmissionLicense());
        }
        return licenseRest;
    }

    public boolean isEmbeddableRelation(LicenseRest data, String name) {
        return false;
    }
}

