/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import org.dspace.app.rest.converter.ResourcePolicyConverter;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.ResourcePolicyRest;
import org.dspace.app.rest.model.hateoas.ResourcePolicyResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="authz.resourcePolicy")
public class ResourcePolicyRestRepository
extends DSpaceRestRepository<ResourcePolicyRest, Integer> {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    ResourcePolicyConverter resourcePolicyConverter;
    @Autowired
    Utils utils;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public ResourcePolicyRest findOne(Context context, Integer id) {
        ResourcePolicy source = null;
        try {
            source = (ResourcePolicy)this.resourcePolicyService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (source == null) {
            return null;
        }
        return (ResourcePolicyRest)this.resourcePolicyConverter.convert((Object)source);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<ResourcePolicyRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("resourcePolicy", "findAll");
    }

    public Class<ResourcePolicyRest> getDomainClass() {
        return ResourcePolicyRest.class;
    }

    public ResourcePolicyResource wrapResource(ResourcePolicyRest model, String ... rels) {
        return new ResourcePolicyResource(model, this.utils, rels);
    }
}

