/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.SubmissionDefinitionConverter;
import org.dspace.app.rest.model.SubmissionDefinitionRest;
import org.dspace.app.rest.model.hateoas.SubmissionDefinitionResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissiondefinition")
public class SubmissionDefinitionRestRepository
extends DSpaceRestRepository<SubmissionDefinitionRest, String> {
    private SubmissionConfigReader submissionConfigReader;
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    @Autowired
    private SubmissionDefinitionConverter converter;

    public SubmissionDefinitionRestRepository() throws SubmissionConfigReaderException {
        this.submissionConfigReader = new SubmissionConfigReader();
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionDefinitionRest findOne(Context context, String submitName) {
        SubmissionConfig subConfig = this.submissionConfigReader.getSubmissionConfigByName(submitName);
        if (subConfig == null) {
            return null;
        }
        return (SubmissionDefinitionRest)this.converter.convert((Object)subConfig);
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionDefinitionRest> findAll(Context context, Pageable pageable) {
        List subConfs = new ArrayList();
        int total = this.submissionConfigReader.countSubmissionConfigs();
        subConfs = this.submissionConfigReader.getAllSubmissionConfigs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
        Page page = new PageImpl(subConfs, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    @SearchRestMethod(name="findByCollection")
    public SubmissionDefinitionRest findByCollection(@Parameter(value="uuid", required=true) UUID collectionUuid) throws SQLException {
        Collection col = (Collection)this.collectionService.find(this.obtainContext(), collectionUuid);
        if (col == null) {
            return null;
        }
        SubmissionDefinitionRest def = (SubmissionDefinitionRest)this.converter.convert((Object)this.submissionConfigReader.getSubmissionConfigByCollection(col.getHandle()));
        return def;
    }

    public Class<SubmissionDefinitionRest> getDomainClass() {
        return SubmissionDefinitionRest.class;
    }

    public SubmissionDefinitionResource wrapResource(SubmissionDefinitionRest sd, String ... rels) {
        return new SubmissionDefinitionResource(sd, this.utils, rels);
    }
}

