/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.converter.SubmissionSectionConverter;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.model.hateoas.SubmissionSectionResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionsection")
public class SubmissionPanelRestRepository
extends DSpaceRestRepository<SubmissionSectionRest, String> {
    private SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();
    @Autowired
    private SubmissionSectionConverter converter;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionSectionRest findOne(Context context, String id) {
        try {
            SubmissionStepConfig step = this.submissionConfigReader.getStepConfig(id);
            return (SubmissionSectionRest)this.converter.convert((Object)step);
        }
        catch (SubmissionConfigReaderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionSectionRest> findAll(Context context, Pageable pageable) {
        List subConfs = new ArrayList();
        subConfs = this.submissionConfigReader.getAllSubmissionConfigs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(pageable.getOffset()));
        int total = 0;
        ArrayList<SubmissionStepConfig> stepConfs = new ArrayList<SubmissionStepConfig>();
        for (SubmissionConfig config : subConfs) {
            total = config.getNumberOfSteps();
            for (int i = 0; i < config.getNumberOfSteps(); ++i) {
                SubmissionStepConfig step = config.getStep(i);
                stepConfs.add(step);
            }
        }
        Page page = new PageImpl(stepConfs, pageable, (long)total).map((Converter)this.converter);
        return page;
    }

    public Class<SubmissionSectionRest> getDomainClass() {
        return SubmissionSectionRest.class;
    }

    public SubmissionSectionResource wrapResource(SubmissionSectionRest model, String ... rels) {
        return new SubmissionSectionResource(model, this.utils, rels);
    }
}

