/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.factories;

import org.dspace.app.rest.exception.PatchBadRequestException;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.repository.patch.factories.impl.EPersonCertificateReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.EPersonEmailReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.EPersonLoginReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.EPersonNetidReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.EPersonPasswordReplaceOperation;
import org.dspace.app.rest.repository.patch.factories.impl.ResourcePatchOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EPersonOperationFactory {
    @Autowired
    EPersonPasswordReplaceOperation passwordReplaceOperation;
    @Autowired
    EPersonLoginReplaceOperation loginReplaceOperation;
    @Autowired
    EPersonCertificateReplaceOperation certificateReplaceOperation;
    @Autowired
    EPersonNetidReplaceOperation netIdReplaceOperation;
    @Autowired
    EPersonEmailReplaceOperation emailReplaceOperation;
    public static final String OPERATION_PASSWORD_CHANGE = "/password";
    public static final String OPERATION_CAN_LOGIN = "/canLogin";
    public static final String OPERATION_REQUIRE_CERTIFICATE = "/certificate";
    public static final String OPERATION_SET_NETID = "/netid";
    public static final String OPERATION_SET_EMAIL = "/email";

    public ResourcePatchOperation<EPersonRest> getReplaceOperationForPath(String path) {
        switch (path) {
            case "/password": {
                return this.passwordReplaceOperation;
            }
            case "/canLogin": {
                return this.loginReplaceOperation;
            }
            case "/certificate": {
                return this.certificateReplaceOperation;
            }
            case "/netid": {
                return this.netIdReplaceOperation;
            }
            case "/email": {
                return this.emailReplaceOperation;
            }
        }
        throw new PatchBadRequestException("Missing patch operation for: " + path);
    }
}

