/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EPersonClaimProvider
implements JWTClaimProvider {
    public static final String EPERSON_ID = "eid";
    @Autowired
    private EPersonService ePersonService;

    public String getKey() {
        return EPERSON_ID;
    }

    public Object getValue(Context context, HttpServletRequest request) {
        return context.getCurrentUser().getID().toString();
    }

    public void parseClaim(Context context, HttpServletRequest request, JWTClaimsSet jwtClaimsSet) throws SQLException {
        EPerson ePerson = this.getEPerson(context, jwtClaimsSet);
        context.setCurrentUser(ePerson);
    }

    public EPerson getEPerson(Context context, JWTClaimsSet jwtClaimsSet) throws SQLException {
        return (EPerson)this.ePersonService.find(context, this.getEPersonId(jwtClaimsSet));
    }

    private UUID getEPersonId(JWTClaimsSet jwtClaimsSet) {
        return UUID.fromString(jwtClaimsSet.getClaim(EPERSON_ID).toString());
    }
}

