/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.jwt.EPersonClaimProvider;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.stereotype.Component;

@Component
public class JWTTokenHandler
implements InitializingBean {
    private static final int MAX_CLOCK_SKEW_SECONDS = 60;
    private static final Logger log = LoggerFactory.getLogger(JWTTokenHandler.class);
    @Autowired
    private List<JWTClaimProvider> jwtClaimProviders;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonClaimProvider ePersonClaimProvider;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ClientInfoService clientInfoService;
    private String jwtKey;
    private long expirationTime;
    private boolean includeIP;
    private boolean encryptionEnabled;
    private boolean compressionEnabled;
    private byte[] encryptionKey;

    public void afterPropertiesSet() throws Exception {
        this.jwtKey = this.getSecret("jwt.token.secret");
        this.encryptionKey = this.getSecret("jwt.encryption.secret").getBytes();
        this.expirationTime = this.configurationService.getLongProperty("jwt.token.expiration", 30L) * 60L * 1000L;
        this.includeIP = this.configurationService.getBooleanProperty("jwt.token.include.ip", true);
        this.encryptionEnabled = this.configurationService.getBooleanProperty("jwt.encryption.enabled", false);
        this.compressionEnabled = this.configurationService.getBooleanProperty("jwt.compression.enabled", false);
    }

    public EPerson parseEPersonFromToken(String token, HttpServletRequest request, Context context) throws JOSEException, ParseException, SQLException {
        EPerson ePerson;
        JWTClaimsSet jwtClaimsSet;
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        SignedJWT signedJWT = this.getSignedJWT(token);
        if (this.isValidToken(request, signedJWT, jwtClaimsSet = signedJWT.getJWTClaimsSet(), ePerson = this.getEPerson(context, jwtClaimsSet))) {
            log.debug("Received valid token for username: " + ePerson.getEmail());
            for (JWTClaimProvider jwtClaimProvider : this.jwtClaimProviders) {
                jwtClaimProvider.parseClaim(context, request, jwtClaimsSet);
            }
            return ePerson;
        }
        log.warn(this.getIpAddress(request) + " tried to use an expired or non-valid token");
        return null;
    }

    public String createTokenForEPerson(Context context, HttpServletRequest request, Date previousLoginDate, List<Group> groups) throws JOSEException, SQLException {
        EPerson ePerson = this.updateSessionSalt(context, previousLoginDate);
        JWTClaimsSet claimsSet = this.buildJwtClaimsSet(context, request);
        SignedJWT signedJWT = this.createSignedJWT(request, ePerson, claimsSet);
        String token = this.isEncryptionEnabled() ? this.encryptJWT(signedJWT).serialize() : signedJWT.serialize();
        return token;
    }

    public void invalidateToken(String token, HttpServletRequest request, Context context) throws Exception {
        EPerson ePerson;
        if (StringUtils.isNotBlank((CharSequence)token) && (ePerson = this.parseEPersonFromToken(token, request, context)) != null) {
            ePerson.setSessionSalt("");
        }
    }

    public long getExpirationPeriod() {
        return this.expirationTime;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    private JWEObject encryptJWT(SignedJWT signedJWT) throws JOSEException {
        JWEObject jweObject = new JWEObject(this.compression(new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A128GCM).contentType("JWT")).build(), new Payload(signedJWT));
        jweObject.encrypt((JWEEncrypter)new DirectEncrypter(this.getEncryptionKey()));
        return jweObject;
    }

    private boolean isValidToken(HttpServletRequest request, SignedJWT signedJWT, JWTClaimsSet jwtClaimsSet, EPerson ePerson) throws JOSEException {
        if (ePerson == null || StringUtils.isBlank((CharSequence)ePerson.getSessionSalt())) {
            return false;
        }
        MACVerifier verifier = new MACVerifier(this.buildSigningKey(request, ePerson));
        Date expirationTime = jwtClaimsSet.getExpirationTime();
        return signedJWT.verify((JWSVerifier)verifier) && expirationTime != null && DateUtils.isAfter((Date)expirationTime, (Date)new Date(), (long)60L);
    }

    private SignedJWT getSignedJWT(String token) throws ParseException, JOSEException {
        SignedJWT signedJWT;
        if (this.isEncryptionEnabled()) {
            JWEObject jweObject = JWEObject.parse((String)token);
            jweObject.decrypt((JWEDecrypter)new DirectDecrypter(this.getEncryptionKey()));
            signedJWT = jweObject.getPayload().toSignedJWT();
        } else {
            signedJWT = SignedJWT.parse((String)token);
        }
        return signedJWT;
    }

    private EPerson getEPerson(Context context, JWTClaimsSet jwtClaimsSet) throws SQLException {
        return this.ePersonClaimProvider.getEPerson(context, jwtClaimsSet);
    }

    private SignedJWT createSignedJWT(HttpServletRequest request, EPerson ePerson, JWTClaimsSet claimsSet) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        MACSigner signer = new MACSigner(this.buildSigningKey(request, ePerson));
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    private JWTClaimsSet buildJwtClaimsSet(Context context, HttpServletRequest request) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (JWTClaimProvider jwtClaimProvider : this.jwtClaimProviders) {
            builder = builder.claim(jwtClaimProvider.getKey(), jwtClaimProvider.getValue(context, request));
        }
        return builder.expirationTime(new Date(System.currentTimeMillis() + this.getExpirationPeriod())).build();
    }

    private JWEHeader.Builder compression(JWEHeader.Builder builder) {
        if (this.compressionEnabled) {
            return builder.compressionAlgorithm(CompressionAlgorithm.DEF);
        }
        return builder;
    }

    private String buildSigningKey(HttpServletRequest request, EPerson ePerson) {
        String ipAddress = "";
        if (this.includeIP) {
            ipAddress = this.getIpAddress(request);
        }
        return this.jwtKey + ePerson.getSessionSalt() + ipAddress;
    }

    private String getIpAddress(HttpServletRequest request) {
        return this.clientInfoService.getClientIp(request);
    }

    private EPerson updateSessionSalt(Context context, Date previousLoginDate) throws SQLException {
        EPerson ePerson;
        try {
            ePerson = context.getCurrentUser();
            if (StringUtils.isBlank((CharSequence)ePerson.getSessionSalt()) || previousLoginDate == null || ePerson.getLastActive().getTime() - previousLoginDate.getTime() > this.expirationTime) {
                ePerson.setSessionSalt(this.generateRandomKey());
                this.ePersonService.update(context, (DSpaceObject)ePerson);
            }
        }
        catch (AuthorizeException e) {
            ePerson = null;
        }
        return ePerson;
    }

    private String getSecret(String property) {
        String secret = this.configurationService.getProperty(property);
        if (StringUtils.isBlank((CharSequence)secret)) {
            secret = this.generateRandomKey();
        }
        return secret;
    }

    private String generateRandomKey() {
        BytesKeyGenerator bytesKeyGenerator = KeyGenerators.secureRandom((int)24);
        byte[] secretKey = bytesKeyGenerator.generateKey();
        return Base64.encodeBase64String((byte[])secretKey);
    }
}

