/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.exception.PaginationException;
import org.dspace.app.rest.exception.RepositoryNotFoundException;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.LinksRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    @Autowired
    ApplicationContext applicationContext;
    @Autowired(required=true)
    private List<DSpaceObjectService<? extends DSpaceObject>> dSpaceObjectServices;

    public <T> Page<T> getPage(List<T> fullContents, Pageable pageable) {
        int total = fullContents.size();
        List<T> pageContent = null;
        if (pageable.getOffset() > total) {
            throw new PaginationException((long)total);
        }
        pageContent = pageable.getOffset() + pageable.getPageSize() > total ? fullContents.subList(pageable.getOffset(), total) : fullContents.subList(pageable.getOffset(), pageable.getOffset() + pageable.getPageSize());
        return new PageImpl(pageContent, pageable, (long)total);
    }

    public Link linkToSingleResource(DSpaceResource r, String rel) {
        RestAddressableModel data = r.getContent();
        return this.linkToSingleResource(data, rel);
    }

    public Link linkToSingleResource(RestAddressableModel data, String rel) {
        return ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)data)).withRel(rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel) {
        return this.linkToSubResource(data, rel, rel);
    }

    public Link linkToSubResource(RestAddressableModel data, String rel, String path) {
        return ((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo((Class)data.getController(), (Object[])new Object[]{data.getCategory(), data.getTypePlural()}).slash((Object)data)).slash((Object)path)).withRel(rel);
    }

    public DSpaceRestRepository getResourceRepository(String apiCategory, String modelPlural) {
        String model = Utils.makeSingular((String)modelPlural);
        try {
            return (DSpaceRestRepository)this.applicationContext.getBean(apiCategory + "." + model, DSpaceRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    public String[] getRepositories() {
        return this.applicationContext.getBeanNamesForType(DSpaceRestRepository.class);
    }

    public static String makeSingular(String modelPlural) {
        if (modelPlural.equals("communities")) {
            return "community";
        }
        if (modelPlural.equals("authorities")) {
            return "authority";
        }
        if (modelPlural.equals("resourcePolicies")) {
            return "resourcePolicy";
        }
        return modelPlural.replaceAll("s$", "");
    }

    public LinkRestRepository getLinkResourceRepository(String apiCategory, String modelPlural, String rel) {
        String model = Utils.makeSingular((String)modelPlural);
        try {
            return (LinkRestRepository)this.applicationContext.getBean(apiCategory + "." + model + "." + rel, LinkRestRepository.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RepositoryNotFoundException(apiCategory, model);
        }
    }

    public LinkRest getLinkRest(String rel, Class<RestAddressableModel> domainClass) {
        LinkRest linkRest = null;
        LinksRest linksAnnotation = domainClass.getDeclaredAnnotation(LinksRest.class);
        if (linksAnnotation != null) {
            LinkRest[] links;
            for (LinkRest l : links = linksAnnotation.links()) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)rel, (CharSequence)l.name())) continue;
                linkRest = l;
                break;
            }
        }
        return linkRest;
    }

    public String getMetadataKey(String schema, String element, String qualifier) {
        return org.dspace.core.Utils.standardize((String)schema, (String)element, (String)qualifier, (String)".");
    }

    public static File getFile(MultipartFile multipartFile, String prefixTempName, String suffixTempName) throws IOException, FileNotFoundException {
        String tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        File uploadDir = new File(tempDir);
        if (!uploadDir.exists() && !uploadDir.mkdir()) {
            uploadDir = null;
        }
        File file = File.createTempFile(prefixTempName + "-" + suffixTempName, ".temp", uploadDir);
        BufferedInputStream io = new BufferedInputStream(multipartFile.getInputStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        org.dspace.core.Utils.bufferedCopy((InputStream)io, (OutputStream)out);
        return file;
    }

    public static String getFileName(MultipartFile multipartFile) throws IOException, FileNotFoundException {
        String originalFilename = multipartFile.getOriginalFilename();
        if (originalFilename != null) {
            String[] parts = originalFilename.split("[\\/]");
            return parts[parts.length - 1];
        }
        return multipartFile.getName();
    }

    public List<DSpaceObject> constructDSpaceObjectList(Context context, List<String> list) {
        LinkedList<DSpaceObject> dSpaceObjects = new LinkedList<DSpaceObject>();
        for (String string : list) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String uuid = string.substring(string.lastIndexOf(47) + 1);
            try {
                for (DSpaceObjectService dSpaceObjectService : this.dSpaceObjectServices) {
                    DSpaceObject dSpaceObject = dSpaceObjectService.find(context, UUIDUtils.fromString((String)uuid));
                    if (dSpaceObject == null) continue;
                    dSpaceObjects.add(dSpaceObject);
                }
            }
            catch (SQLException e) {
                log.error((Object)("Could not find DSpaceObject for UUID: " + uuid), (Throwable)e);
            }
        }
        return dSpaceObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromRequest(HttpServletRequest request) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        try (Scanner scanner = new Scanner((InputStream)request.getInputStream());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!StringUtils.hasText((String)line)) continue;
                list.add(line);
            }
        }
        return list;
    }

    public List<String> getStringListFromRequest(HttpServletRequest request) {
        List list = null;
        try {
            list = this.readFromRequest(request);
        }
        catch (IOException e) {
            log.error((Object)"Something went wrong with reading in the inputstream from the request", (Throwable)e);
        }
        return list;
    }
}

