/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class SimpleFileIngester
implements SWORDIngester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepositResult ingest(SWORDService service, Deposit deposit, DSpaceObject target) throws DSpaceSWORDException, SWORDErrorException {
        try {
            Bitstream bs;
            if (!(target instanceof Item)) {
                throw new DSpaceSWORDException("SimpleFileIngester can only be loaded for deposit onto DSpace Items");
            }
            Item item = (Item)target;
            SWORDService swordService = service;
            Context context = swordService.getContext();
            SWORDUrlManager urlManager = swordService.getUrlManager();
            Bundle[] bundles = item.getBundles("ORIGINAL");
            Bundle original = bundles.length > 0 ? bundles[0] : item.createBundle("ORIGINAL");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(deposit.getFile());
                bs = original.createBitstream((InputStream)fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            String fn = swordService.getFilename(context, deposit, false);
            bs.setName(fn);
            swordService.message("File created in item with filename " + fn);
            BitstreamFormat bf = BitstreamFormat.findByMIMEType((Context)context, (String)deposit.getContentType());
            if (bf != null) {
                bs.setFormat(bf);
            }
            boolean ignoreAuth = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            bs.update();
            original.update();
            item.update();
            context.setIgnoreAuthorization(ignoreAuth);
            DepositResult result = new DepositResult();
            result.setHandle(urlManager.getBitstreamUrl(bs));
            result.setTreatment(this.getTreatment());
            result.setBitstream(bs);
            return result;
        }
        catch (SQLException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    private String getTreatment() {
        return "The file has been attached to the specified item";
    }
}

