/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class Generator
extends XmlElement
implements SwordElementInterface {
    public static final String ATTRIBUTE_URI = "uri";
    public static final String ATTRIBUTE_VERSION = "version";
    @Deprecated
    public static final String ELEMENT_NAME = "generator";
    private String content;
    private String uri;
    private String version;
    private static Logger log = Logger.getLogger(Generator.class);
    private static final XmlName XML_NAME = new XmlName("atom", "generator", "http://www.w3.org/2005/Atom");

    public Generator() {
        super(XML_NAME);
        this.initialise();
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    protected final void initialise() {
        this.content = null;
        this.version = null;
        this.uri = null;
    }

    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), this.xmlName.getNamespace());
        if (this.content != null) {
            element.appendChild(this.content);
        }
        if (this.uri != null) {
            Attribute uriAttribute = new Attribute(ATTRIBUTE_URI, this.uri);
            element.addAttribute(uriAttribute);
        }
        if (this.version != null) {
            Attribute versionAttribute = new Attribute(ATTRIBUTE_VERSION, this.version);
            element.addAttribute(versionAttribute);
        }
        return element;
    }

    public void unmarshall(Element generator) throws UnmarshallException {
        this.unmarshall(generator, null);
    }

    public SwordValidationInfo unmarshall(Element generator, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(generator, this.xmlName)) {
            return this.handleIncorrectElement(generator, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributeValidationItems = new ArrayList<SwordValidationInfo>();
        try {
            this.initialise();
            int attributeCount = generator.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                SwordValidationInfo info;
                attribute = generator.getAttribute(i);
                if (ATTRIBUTE_URI.equals(attribute.getQualifiedName())) {
                    this.uri = attribute.getValue();
                    XmlName uriName = new XmlName("atom", ATTRIBUTE_URI, "http://www.w3.org/2005/Atom");
                    info = new SwordValidationInfo(this.xmlName, uriName);
                    info.setContentDescription(this.uri);
                    attributeValidationItems.add(info);
                    continue;
                }
                if (ATTRIBUTE_VERSION.equals(attribute.getQualifiedName())) {
                    this.version = attribute.getValue();
                    XmlName versionName = new XmlName("atom", ATTRIBUTE_VERSION, "http://www.w3.org/2005/Atom");
                    info = new SwordValidationInfo(this.xmlName, versionName);
                    info.setContentDescription(this.version);
                    attributeValidationItems.add(info);
                    continue;
                }
                XmlName attributeName = new XmlName(attribute.getNamespacePrefix(), attribute.getLocalName(), attribute.getNamespaceURI());
                info = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(attribute.getValue());
                validationItems.add(info);
            }
            int length = generator.getChildCount();
            if (length > 0) {
                this.content = this.unmarshallString(generator);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in Generator: " + ex.getMessage()));
            throw new UnmarshallException("Unable to parse element in Generator", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeValidationItems, validationProperties);
        }
        return result;
    }

    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    public SwordValidationInfo validate(List<SwordValidationInfo> existing, List<SwordValidationInfo> attributeItems, Properties validationContext) {
        XmlName attributeName;
        boolean validateAll = existing == null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        result.setContentDescription(this.content);
        if (this.content == null) {
            result.addValidationInfo(new SwordValidationInfo(this.xmlName, "No content is defined. This element should have content.", SwordValidationInfoType.WARNING));
        }
        if (this.uri == null) {
            attributeName = new XmlName("atom", ATTRIBUTE_URI, "http://www.w3.org/2005/Atom");
            result.addAttributeValidationInfo(new SwordValidationInfo(this.xmlName, attributeName, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        } else if (validateAll && this.uri != null) {
            result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_URI, this.uri));
        }
        if (this.version == null) {
            attributeName = new XmlName("atom", ATTRIBUTE_VERSION, "http://www.w3.org/2005/Atom");
            result.addAttributeValidationInfo(new SwordValidationInfo(this.xmlName, attributeName, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        } else if (validateAll && this.version != null) {
            result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_VERSION, this.version));
        }
        result.addUnmarshallValidationInfo(existing, attributeItems);
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Generator - content: " + this.getContent() + " version: " + this.getVersion() + " uri: " + this.getUri();
    }
}

