/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.XmlName;

public class SwordValidationInfo {
    private XmlName elementName;
    private XmlName attributeName;
    private String contentDescription;
    private String message;
    private SwordValidationInfoType type;
    private List<SwordValidationInfo> elementInfo;
    private List<SwordValidationInfo> attributeInfo;
    private List<SwordValidationInfo> unmarshallElementInfo;
    private List<SwordValidationInfo> unmarshallAttributeInfo;
    public static final String UNKNOWN_ELEMENT = "This element is present, but it is not used as part of the SWORD profile";
    public static final String UNKNOWN_ATTRIBUTE = "This attribute is present, but it is not used as part of the SWORD profile";
    public static final String MISSING_ELEMENT_WARNING = "This element is not present, but it SHOULD be included.";
    public static final String MISSING_ATTRIBUTE_WARNING = "This attribute is not present, but it SHOULD be included.";
    public static final String DUPLICATE_ELEMENT = "This element has already been included earlier in this document. This element is ignored.";
    public static final String MISSING_CONTENT = "No content is defined. This element should have content.";
    public static final String MISSING_ELEMENT_ERROR = "This element is not present, but at least one MUST be included.";
    public static final String ERROR_WITH_CONTENT = "There is an error with the value.";

    public SwordValidationInfo(XmlName element) {
        this(element, null, "", SwordValidationInfoType.VALID);
    }

    public SwordValidationInfo(XmlName element, XmlName attribute) {
        this(element, attribute, "", SwordValidationInfoType.VALID);
    }

    public SwordValidationInfo(XmlName element, String theMessage, SwordValidationInfoType theType) {
        this(element, null, theMessage, theType);
    }

    public SwordValidationInfo(XmlName element, XmlName attribute, String theMessage, SwordValidationInfoType theType) {
        this.elementName = element;
        this.attributeName = attribute;
        this.message = theMessage;
        this.type = theType;
        this.elementInfo = new ArrayList();
        this.attributeInfo = new ArrayList();
        this.unmarshallElementInfo = new ArrayList();
        this.unmarshallAttributeInfo = new ArrayList();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SwordValidationInfoType getType() {
        return this.type;
    }

    public void setType(SwordValidationInfoType type) {
        this.type = type;
    }

    public XmlName getElement() {
        return this.elementName;
    }

    public void setElement(XmlName element) {
        this.elementName = element;
    }

    public XmlName getAttribute() {
        return this.attributeName;
    }

    public void setAttribute(XmlName attribute) {
        this.attributeName = attribute;
    }

    public void addValidationInfo(SwordValidationInfo item) {
        if (this.type.compareTo((Enum)item.getType()) < 0) {
            this.type = item.getType();
        }
        this.elementInfo.add(item);
    }

    public void addAttributeValidationInfo(SwordValidationInfo attribute) {
        if (this.type.compareTo((Enum)attribute.getType()) < 0) {
            this.type = attribute.getType();
        }
        this.attributeInfo.add(attribute);
    }

    public void addUnmarshallElementInfo(SwordValidationInfo unmarshallElement) {
        if (unmarshallElement == null) {
            return;
        }
        if (this.type.compareTo((Enum)unmarshallElement.getType()) < 0) {
            this.type = unmarshallElement.getType();
        }
        this.unmarshallElementInfo.add(unmarshallElement);
    }

    public void addUnmarshallAttributeInfo(SwordValidationInfo unmarshallAttribute) {
        if (this.type.compareTo((Enum)unmarshallAttribute.getType()) < 0) {
            this.type = unmarshallAttribute.getType();
        }
        this.unmarshallAttributeInfo.add(unmarshallAttribute);
    }

    public void clearValidationItems() {
        this.elementInfo.clear();
        this.attributeInfo.clear();
        this.resetType();
    }

    public void clearUnmarshallItems() {
        this.unmarshallElementInfo.clear();
        this.unmarshallAttributeInfo.clear();
        this.resetType();
    }

    protected void resetType() {
        this.type = SwordValidationInfoType.VALID;
        this.resetType(this.getValidationElementInfoIterator());
        this.resetType(this.getValidationAttributeInfoIterator());
        this.resetType(this.getUnmarshallElementInfoIterator());
        this.resetType(this.getUnmarshallAttributeInfoIterator());
    }

    protected void resetType(Iterator<SwordValidationInfo> iterator) {
        SwordValidationInfo item = null;
        while (iterator.hasNext()) {
            item = iterator.next();
            if (item == null || this.type.compareTo((Enum)item.getType()) >= 0) continue;
            this.type = item.getType();
        }
    }

    public Iterator<SwordValidationInfo> getValidationElementInfoIterator() {
        return this.elementInfo.iterator();
    }

    public Iterator<SwordValidationInfo> getValidationAttributeInfoIterator() {
        return this.attributeInfo.iterator();
    }

    public Iterator<SwordValidationInfo> getUnmarshallElementInfoIterator() {
        return this.unmarshallElementInfo.iterator();
    }

    public Iterator<SwordValidationInfo> getUnmarshallAttributeInfoIterator() {
        return this.unmarshallAttributeInfo.iterator();
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    public void addUnmarshallValidationInfo(List<SwordValidationInfo> elementItems, List<SwordValidationInfo> attributeItems) {
        if (elementItems != null) {
            Iterator<SwordValidationInfo> items = elementItems.iterator();
            while (items.hasNext()) {
                this.addUnmarshallElementInfo(items.next());
            }
        }
        if (attributeItems != null) {
            Iterator<SwordValidationInfo> attributes = attributeItems.iterator();
            while (attributes.hasNext()) {
                this.addUnmarshallAttributeInfo(attributes.next());
            }
        }
    }

    public void addUnmarshallValidationInfo(SwordValidationInfo other) {
        this.addUnmarshallValidationInfo(other.elementInfo, other.attributeInfo);
    }

    public String toString() {
        return "" + this.getType();
    }

    public void createString(SwordValidationInfo info, StringBuffer buffer, String indent) {
        String prefix = info.getElement().getPrefix();
        buffer.append(indent);
        buffer.append("[");
        buffer.append(info.getType());
        buffer.append("]");
        if (prefix != null && prefix.trim().length() > 0) {
            buffer.append(prefix);
            buffer.append(":");
        }
        buffer.append(info.getElement().getLocalName());
        buffer.append("  ");
        if (info.getAttribute() != null) {
            buffer.append(info.getAttribute().getLocalName());
            buffer.append("=\"");
            if (info.getContentDescription() != null) {
                buffer.append(info.getContentDescription());
            }
            buffer.append("\"");
        } else if (info.getContentDescription() != null) {
            buffer.append(" Value: '");
            buffer.append(info.getContentDescription());
            buffer.append("'");
        }
        buffer.append("\n" + indent + "message: ");
        buffer.append(info.getMessage());
        buffer.append("\n");
        Iterator iterator = info.getValidationAttributeInfoIterator();
        while (iterator.hasNext()) {
            this.createString((SwordValidationInfo)iterator.next(), buffer, "   " + indent);
        }
        iterator = info.getUnmarshallAttributeInfoIterator();
        while (iterator.hasNext()) {
            this.createString((SwordValidationInfo)iterator.next(), buffer, "   " + indent);
        }
        iterator = info.getValidationElementInfoIterator();
        while (iterator.hasNext()) {
            this.createString((SwordValidationInfo)iterator.next(), buffer, "   " + indent);
        }
        iterator = info.getUnmarshallElementInfoIterator();
        while (iterator.hasNext()) {
            this.createString((SwordValidationInfo)iterator.next(), buffer, "   " + indent);
        }
    }
}

