/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class XmlName {
    private String prefix;
    private String localName;
    private String namespace;

    public XmlName(String prefix, String localName, String namespace) {
        this.prefix = prefix;
        this.localName = localName;
        this.namespace = namespace;
    }

    public XmlName(Element element) {
        this.prefix = element.getNamespacePrefix();
        this.localName = element.getLocalName();
        this.namespace = element.getNamespaceURI();
    }

    public XmlName(Attribute attribute) {
        this.prefix = attribute.getNamespacePrefix();
        this.localName = attribute.getLocalName();
        this.namespace = attribute.getNamespaceURI();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getQualifiedName() {
        String qName = "";
        if (this.prefix != null && this.prefix.trim().length() > 0) {
            qName = this.prefix + ":";
        }
        qName = qName + this.localName;
        return qName;
    }

    public boolean equals(Object other) {
        if (other instanceof XmlName) {
            XmlName otherName = (XmlName)other;
            return StringUtils.equals((String)this.namespace, (String)otherName.namespace) && StringUtils.equals((String)this.localName, (String)otherName.localName);
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.namespace).append((Object)this.localName).hashCode();
    }
}

