/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.purl.sword.client.PostDestination;
import org.purl.sword.client.SWORDComboBox;
import org.purl.sword.client.SWORDFormPanel;

public class PostDialog
implements ActionListener,
ChangeListener {
    protected static final String BROWSE = "browse";
    protected static final String ADD = "add";
    protected static final String EDIT = "edit";
    protected static final String DELETE = "delete";
    protected static final String CLEAR = "clear";
    private SWORDComboBox username;
    private SWORDComboBox postLocation;
    private JPasswordField password;
    private SWORDComboBox file;
    private SWORDComboBox fileType;
    private SWORDComboBox onBehalfOf;
    private JCheckBox useMD5;
    private JCheckBox corruptMD5;
    private JCheckBox corruptRequest;
    private JCheckBox useNoOp;
    private JCheckBox useVerbose;
    private SWORDComboBox formatNamespace;
    private JList list;
    private JFrame parentFrame = null;
    private static Object[] options = new Object[]{"Post File", "Cancel"};
    private JPanel controls = null;

    public PostDialog(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.controls = this.createControls();
    }

    public int show() {
        int result = JOptionPane.showOptionDialog(this.parentFrame, this.controls, "Post Document", 2, -1, null, options, null);
        if (result == 0) {
            this.username.updateList();
            this.file.updateList();
            this.fileType.updateList();
            this.onBehalfOf.updateList();
            this.formatNamespace.updateList();
        }
        return result;
    }

    protected final JPanel createControls() {
        this.file = new SWORDComboBox();
        JPanel filePanel = new JPanel(new BorderLayout());
        filePanel.add((Component)this.file, "Center");
        JButton browse = new JButton("Browse...");
        browse.setActionCommand(BROWSE);
        browse.addActionListener((ActionListener)this);
        filePanel.add((Component)browse, "South");
        this.fileType = new SWORDComboBox();
        String type = "application/zip";
        this.fileType.addItem((Object)type);
        this.fileType.setSelectedItem((Object)type);
        this.postLocation = new SWORDComboBox();
        this.username = new SWORDComboBox();
        this.password = new JPasswordField();
        this.onBehalfOf = new SWORDComboBox();
        this.useMD5 = new JCheckBox();
        this.useMD5.addChangeListener((ChangeListener)this);
        this.corruptMD5 = new JCheckBox();
        this.corruptRequest = new JCheckBox();
        this.useNoOp = new JCheckBox();
        this.useVerbose = new JCheckBox();
        this.formatNamespace = new SWORDComboBox();
        JLabel fileLabel = new JLabel("File:", 11);
        JLabel fileTypeLabel = new JLabel("File Type:", 11);
        JLabel useMD5Label = new JLabel("Use MD5:", 11);
        JLabel corruptMD5Label = new JLabel("Corrupt MD5:", 11);
        JLabel corruptRequestLabel = new JLabel("Corrupt Request:", 11);
        JLabel useNoOpLabel = new JLabel("Use noOp:", 11);
        JLabel useVerboseLabel = new JLabel("Use verbose:", 11);
        JLabel formatNamespaceLabel = new JLabel("X-Packaging:", 11);
        JLabel userAgentLabel = new JLabel("User Agent:", 11);
        JLabel userAgentNameLabel = new JLabel("CASIS Test Client", 10);
        SWORDFormPanel panel = new SWORDFormPanel();
        panel.addFirstRow((Component)new JLabel("Please enter the details for the post operation"));
        JPanel destinations = this.createDestinationsPanel();
        panel.addRow((Component)new JLabel("Destinations:"), (Component)destinations);
        panel.addRow((Component)fileLabel, (Component)filePanel);
        panel.addRow((Component)fileTypeLabel, (Component)this.fileType);
        panel.addRow((Component)useMD5Label, (Component)this.useMD5);
        panel.addRow((Component)corruptMD5Label, (Component)this.corruptMD5);
        panel.addRow((Component)corruptRequestLabel, (Component)this.corruptRequest);
        panel.addRow((Component)useNoOpLabel, (Component)this.useNoOp);
        panel.addRow((Component)useVerboseLabel, (Component)this.useVerbose);
        panel.addRow((Component)formatNamespaceLabel, (Component)this.formatNamespace);
        panel.addRow((Component)userAgentLabel, (Component)userAgentNameLabel);
        return panel;
    }

    protected JPanel createDestinationsPanel() {
        DefaultListModel model = new DefaultListModel();
        this.list = new JList(model);
        JScrollPane jsp = new JScrollPane(this.list);
        JPanel destinations = new JPanel(new BorderLayout());
        destinations.add((Component)jsp, "Center");
        JPanel destinationButtons = new JPanel();
        JButton addButton = new JButton("Add");
        addButton.setActionCommand(ADD);
        addButton.addActionListener((ActionListener)this);
        JButton editButton = new JButton("Edit");
        editButton.setActionCommand(EDIT);
        editButton.addActionListener((ActionListener)this);
        JButton deleteButton = new JButton("Delete");
        deleteButton.setActionCommand(DELETE);
        deleteButton.addActionListener((ActionListener)this);
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand(CLEAR);
        clearButton.addActionListener((ActionListener)this);
        destinationButtons.add(addButton);
        destinationButtons.add(editButton);
        destinationButtons.add(deleteButton);
        destinationButtons.add(clearButton);
        destinations.add((Component)destinationButtons, "South");
        return destinations;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (BROWSE.equals(cmd)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            int returnVal = chooser.showOpenDialog(this.parentFrame);
            if (returnVal == 0) {
                this.file.setSelectedItem((Object)chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (ADD.equals(cmd)) {
            PostDestination dest = this.showDestinationDialog(null);
            if (dest != null) {
                ((DefaultListModel)this.list.getModel()).addElement(dest);
            }
        } else if (EDIT.equals(cmd)) {
            PostDestination dest = (PostDestination)this.list.getSelectedValue();
            if (dest != null) {
                this.showDestinationDialog(dest);
                this.list.repaint();
            }
        } else if (DELETE.equals(cmd)) {
            if (this.list.getSelectedIndex() != -1) {
                ((DefaultListModel)this.list.getModel()).removeElementAt(this.list.getSelectedIndex());
            }
        } else if (CLEAR.equals(cmd)) {
            ((DefaultListModel)this.list.getModel()).clear();
        }
    }

    public PostDestination showDestinationDialog(PostDestination destination) {
        SWORDFormPanel panel = new SWORDFormPanel();
        panel.addFirstRow((Component)new JLabel("Please enter the details for the post operation"));
        JLabel postLabel = new JLabel("Post Location:", 11);
        JLabel userLabel = new JLabel("Username:", 11);
        JLabel passwordLabel = new JLabel("Password:", 11);
        JLabel onBehalfOfLabel = new JLabel("On Behalf Of:", 11);
        panel.addRow((Component)postLabel, (Component)this.postLocation);
        panel.addRow((Component)userLabel, (Component)this.username);
        panel.addRow((Component)passwordLabel, (Component)this.password);
        panel.addRow((Component)onBehalfOfLabel, (Component)this.onBehalfOf);
        if (destination != null) {
            this.postLocation.insertItem((Object)destination.getUrl());
            this.username.insertItem((Object)destination.getUsername());
            this.password.setText(destination.getPassword());
            this.onBehalfOf.insertItem((Object)destination.getOnBehalfOf());
        } else {
            String s = "";
            this.postLocation.insertItem((Object)s);
            this.username.insertItem((Object)s);
            this.username.setSelectedItem((Object)s);
            this.password.setText(s);
            this.onBehalfOf.insertItem((Object)s);
            this.onBehalfOf.setSelectedItem((Object)s);
        }
        int result = JOptionPane.showOptionDialog(null, panel, "Destination", 2, -1, null, new String[]{"OK", "Cancel"}, null);
        if (result == 0) {
            this.postLocation.updateList();
            this.username.updateList();
            this.onBehalfOf.updateList();
            if (destination == null) {
                destination = new PostDestination();
            }
            destination.setUrl(this.postLocation.getText());
            destination.setUsername(this.username.getText());
            String pass = new String(this.password.getPassword());
            if (pass.length() > 0) {
                destination.setPassword(pass);
            } else {
                destination.setPassword(null);
            }
            String obo = this.onBehalfOf.getText();
            if (obo.length() > 0) {
                destination.setOnBehalfOf(this.onBehalfOf.getText());
            } else {
                destination.setOnBehalfOf(null);
            }
        }
        return destination;
    }

    public PostDestination[] getDestinations() {
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        PostDestination[] destinations = new PostDestination[model.size()];
        for (int i = 0; i < model.size(); ++i) {
            destinations[i] = (PostDestination)model.get(i);
        }
        return destinations;
    }

    public String getFile() {
        return this.file.getText();
    }

    public String getFileType() {
        return this.fileType.getText();
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf.getText();
    }

    public String getFormatNamespace() {
        return this.formatNamespace.getText();
    }

    public boolean useMd5() {
        return this.useMD5.isSelected();
    }

    public boolean useNoOp() {
        return this.useNoOp.isSelected();
    }

    public boolean useVerbose() {
        return this.useVerbose.isSelected();
    }

    public String getPostLocation() {
        return this.postLocation.getText();
    }

    public boolean corruptMD5() {
        return this.corruptMD5.isEnabled() && this.corruptMD5.isSelected();
    }

    public boolean corruptRequest() {
        return this.corruptRequest.isSelected();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.corruptMD5.setEnabled(this.useMD5.isSelected());
    }

    public void addUserIds(String[] users) {
        this.username.insertItems(users);
    }

    public void addDepositUrls(String[] deposits) {
        this.postLocation.insertItems(deposits);
    }

    public void addOnBehalfOf(String[] users) {
        this.onBehalfOf.insertItems(users);
    }

    public void addFormatNamespaces(String[] namespaces) {
        this.formatNamespace.insertItems(namespaces);
    }

    public void addFileTypes(String[] types) {
        this.fileType.insertItems(types);
    }

    public void addFiles(String[] files) {
        this.file.insertItems(files);
    }

    public void setDepositLocation(String location) {
        this.postLocation.insertItem((Object)location);
        this.postLocation.setSelectedItem((Object)location);
    }
}

