/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.sword.DSpaceATOMEntry;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.ContentType;
import org.purl.sword.atom.InvalidMediaTypeException;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.Rights;
import org.purl.sword.atom.Title;

public class BitstreamEntryGenerator
extends DSpaceATOMEntry {
    private static Logger log = Logger.getLogger(BitstreamEntryGenerator.class);

    protected BitstreamEntryGenerator(SWORDService service) {
        super(service);
        log.debug((Object)"Create new instance of BitstreamEntryGenerator");
    }

    protected void addCategories() {
    }

    protected void addContentElement() throws DSpaceSWORDException {
        try {
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            if (this.deposit != null && this.deposit.isNoOp()) {
                return;
            }
            String bsurl = urlManager.getBitstreamUrl(this.bitstream);
            BitstreamFormat bf = this.bitstream.getFormat();
            String format = "application/octet-stream";
            if (bf != null) {
                format = bf.getMIMEType();
            }
            Content con = new Content();
            con.setType(format);
            con.setSource(bsurl);
            this.entry.setContent(con);
            log.debug((Object)("Adding content element with url=" + bsurl));
        }
        catch (InvalidMediaTypeException e) {
            log.error((Object)"caught and swallowed exception: ", (Throwable)e);
        }
    }

    protected void addIdentifier() throws DSpaceSWORDException {
        if (this.deposit != null && this.deposit.isNoOp()) {
            String cfg = ConfigurationManager.getProperty((String)"dspace.url");
            this.entry.setId(cfg);
            return;
        }
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        String bsurl = urlManager.getBitstreamUrl(this.bitstream);
        this.entry.setId(bsurl);
        log.debug((Object)("Added identifier for bitstream with url=" + bsurl));
    }

    protected void addLinks() throws DSpaceSWORDException {
        if (this.deposit != null && this.deposit.isNoOp()) {
            return;
        }
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        String bsurl = urlManager.getBitstreamUrl(this.bitstream);
        BitstreamFormat bf = this.bitstream.getFormat();
        String format = "application/octet-stream";
        if (bf != null) {
            format = bf.getMIMEType();
        }
        Link link = new Link();
        link.setType(format);
        link.setHref(bsurl);
        link.setRel("alternate");
        this.entry.addLink(link);
        log.debug((Object)("Added link entity to entry for url " + bsurl));
    }

    protected void addPublishDate() {
    }

    protected void addRights() throws DSpaceSWORDException {
        try {
            Bundle[] bundles = this.bitstream.getBundles();
            if (bundles.length == 0) {
                log.error((Object)("Found orphaned bitstream: " + this.bitstream.getID()));
                throw new DSpaceSWORDException("Orphaned bitstream discovered");
            }
            Item[] items = bundles[0].getItems();
            if (items.length == 0) {
                log.error((Object)("Found orphaned bundle: " + bundles[0].getID()));
                throw new DSpaceSWORDException("Orphaned bundle discovered");
            }
            Item item = items[0];
            SWORDUrlManager urlManager = this.swordService.getUrlManager();
            StringBuilder rightsString = new StringBuilder();
            Bundle[] lbundles = item.getBundles("LICENSE");
            for (int i = 0; i < lbundles.length; ++i) {
                Bitstream[] bss = lbundles[i].getBitstreams();
                for (int j = 0; j < bss.length; ++j) {
                    String url = urlManager.getBitstreamUrl(bss[j]);
                    rightsString.append(url + " ");
                }
            }
            Rights rights = new Rights();
            rights.setContent(rightsString.toString());
            rights.setType(ContentType.TEXT);
            this.entry.setRights(rights);
            log.debug((Object)"Added rights entry to entity");
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    protected void addSummary() {
    }

    protected void addTitle() {
        Title title = new Title();
        title.setContent(this.bitstream.getName());
        title.setType(ContentType.TEXT);
        this.entry.setTitle(title);
        log.debug((Object)"Added title to entry");
    }

    protected void addLastUpdatedDate() {
    }
}

