/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.purl.sword.base.Service;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.UnmarshallException;

public class ServiceDocument {
    private Service service;

    public ServiceDocument() {
    }

    public ServiceDocument(String version) {
        this.service = new Service(version);
    }

    public ServiceDocument(Service service) {
        this.service = service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Service getService() {
        return this.service;
    }

    public String toString() {
        return this.marshall();
    }

    public String marshall() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)stream, "UTF-8");
            serializer.setIndent(3);
            Document doc = new Document(this.service.marshall());
            serializer.write(doc);
            return stream.toString();
        }
        catch (IOException ex) {
            System.err.println(ex);
            return null;
        }
    }

    public void unmarshall(String xml) throws UnmarshallException {
        this.unmarshall(xml, null);
    }

    public SwordValidationInfo unmarshall(String xml, Properties validationProperties) throws UnmarshallException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(xml, "app");
            Element root = doc.getRootElement();
            return this.unmarshall(root, validationProperties);
        }
        catch (ParsingException ex) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new UnmarshallException("Error acessing the file?", (Exception)ex);
        }
    }

    public void unmarshall(Element element) throws UnmarshallException {
        this.unmarshall(element, null);
    }

    public SwordValidationInfo unmarshall(Element element, Properties validationProperties) throws UnmarshallException {
        this.service = new Service();
        try {
            return this.service.unmarshall(element, validationProperties);
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)e));
        }
    }

    public SwordValidationInfo validate() {
        if (this.service == null) {
            return null;
        }
        return this.service.validate(new Properties());
    }

    public SwordValidationInfo validate(Properties validationContext) {
        if (this.service == null) {
            return null;
        }
        return this.service.validate(validationContext);
    }
}

