/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.purl.sword.atom.Author;
import org.purl.sword.atom.Content;
import org.purl.sword.atom.Contributor;
import org.purl.sword.atom.Generator;
import org.purl.sword.atom.Link;
import org.purl.sword.atom.TextConstruct;
import org.purl.sword.base.Collection;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordAcceptPackaging;
import org.purl.sword.base.Workspace;
import org.purl.sword.client.ServicePanel;
import org.purl.sword.client.ServiceSelectedListener;

public class ServicePanel
extends JPanel
implements TreeSelectionListener {
    DefaultMutableTreeNode top;
    DefaultTreeModel treeModel = null;
    private JTree services;
    private JEditorPane details;
    private ServiceSelectedListener listener;

    public ServicePanel() {
        this.setLayout((LayoutManager)new BorderLayout());
        this.top = new DefaultMutableTreeNode("Services & Posted Files");
        this.treeModel = new DefaultTreeModel(this.top);
        this.services = new JTree(this.treeModel);
        this.services.setCellRenderer((TreeCellRenderer)new ServicePostTreeRenderer());
        JScrollPane servicesPane = new JScrollPane(this.services, 22, 32);
        this.details = new JEditorPane("text/html", "<html><body><h1>Details</h1><p>This panel will show the details for the currently selected item in the tree.</p></body></html>");
        JScrollPane detailsPane = new JScrollPane(this.details, 22, 32);
        JSplitPane splitPane = new JSplitPane(1, servicesPane, detailsPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(200);
        this.services.addTreeSelectionListener((TreeSelectionListener)this);
        ToolTipManager.sharedInstance().registerComponent(this.services);
        this.add((Component)splitPane, (Object)"Center");
    }

    public void setServiceSelectedListener(ServiceSelectedListener listener) {
        this.listener = listener;
    }

    public void processServiceDocument(String url, ServiceDocument doc) {
        TreeNodeWrapper wrapper = null;
        Service service = doc.getService();
        wrapper = new TreeNodeWrapper(url, (Object)service);
        DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(wrapper);
        this.treeModel.insertNodeInto(serviceNode, this.top, this.top.getChildCount());
        this.services.scrollPathToVisible(new TreePath(serviceNode.getPath()));
        DefaultMutableTreeNode workspaceNode = null;
        Iterator workspaces = service.getWorkspaces();
        while (workspaces.hasNext()) {
            Workspace workspace = (Workspace)workspaces.next();
            wrapper = new TreeNodeWrapper(workspace.getTitle(), (Object)workspace);
            workspaceNode = new DefaultMutableTreeNode(wrapper);
            this.treeModel.insertNodeInto(workspaceNode, serviceNode, serviceNode.getChildCount());
            this.services.scrollPathToVisible(new TreePath(workspaceNode.getPath()));
            DefaultMutableTreeNode collectionNode = null;
            Iterator collections = workspace.collectionIterator();
            while (collections.hasNext()) {
                Collection collection = (Collection)collections.next();
                wrapper = new TreeNodeWrapper(collection.getTitle(), (Object)collection);
                collectionNode = new DefaultMutableTreeNode(wrapper);
                this.treeModel.insertNodeInto(collectionNode, workspaceNode, workspaceNode.getChildCount());
                this.services.scrollPathToVisible(new TreePath(collectionNode.getPath()));
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath[] paths = evt.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            if (!evt.isAddedPath(i)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof TreeNodeWrapper) {
                try {
                    TreeNodeWrapper wrapper = (TreeNodeWrapper)o;
                    Object data = wrapper.getData();
                    if (data instanceof Service) {
                        this.showService((Service)data);
                        this.alertListener(null);
                        continue;
                    }
                    if (data instanceof Workspace) {
                        this.showWorkspace((Workspace)data);
                        if (this.listener == null) continue;
                        this.alertListener(null);
                        continue;
                    }
                    if (data instanceof Collection) {
                        Collection c = (Collection)data;
                        this.showCollection(c);
                        this.alertListener(c.getLocation());
                        continue;
                    }
                    if (data instanceof SWORDEntry) {
                        this.showEntry((SWORDEntry)data);
                        this.alertListener(null);
                        continue;
                    }
                    this.details.setText("<html><body>unknown</body></html>");
                    this.alertListener(null);
                }
                catch (Exception e) {
                    this.details.setText("<html><body>An error occurred. The message was: " + e.getMessage() + "</body></html>");
                    this.alertListener(null);
                    e.printStackTrace();
                }
                continue;
            }
            this.details.setText("<html><body>please select one of the other nodes</body></html>");
            this.alertListener(null);
        }
    }

    private void alertListener(String value) {
        if (this.listener != null) {
            this.listener.selected(value);
        }
    }

    private void addTableRow(StringBuffer buffer, String label, Object value) {
        buffer.append("<tr bgcolor=\"#ffffff;\"><td>");
        buffer.append(label);
        buffer.append("</td><td>");
        buffer.append(this.displayableValue(value));
        buffer.append("</td></tr>");
    }

    private void showService(Service service) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<table border=\"1\" width=\"100%\">");
        buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Service Summary</font></td></tr>");
        this.addTableRow(buffer, "SWORD Version", (Object)service.getVersion());
        this.addTableRow(buffer, "NoOp Support ", (Object)service.isNoOp());
        this.addTableRow(buffer, "Verbose Support ", (Object)service.isVerbose());
        String maxSize = "";
        maxSize = "undefined";
        this.addTableRow(buffer, "Max File Upload Size ", (Object)maxSize);
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private void showWorkspace(Workspace workspace) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<table border=\"1\" width=\"100%\">");
        buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Workspace Summary</font></td></tr>");
        this.addTableRow(buffer, "Workspace Title", (Object)workspace.getTitle());
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private Object displayableValue(Object s) {
        if (null == s) {
            return "Not defined";
        }
        return s;
    }

    private void addPara(StringBuffer buffer, String message) {
        buffer.append("<p>" + message + "</p>");
    }

    private void showCollection(Collection collection) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        if (collection == null) {
            this.addPara(buffer, "Invalid Collection object. Unable to display details.");
        } else {
            buffer.append("<table border=\"1\" width=\"100%\">");
            buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Collection Summary</font></td></tr>");
            this.addTableRow(buffer, "Collection location", (Object)collection.getLocation());
            this.addTableRow(buffer, "Collection title", (Object)collection.getTitle());
            this.addTableRow(buffer, "Abstract", (Object)collection.getAbstract());
            this.addTableRow(buffer, "Collection Policy", (Object)collection.getCollectionPolicy());
            this.addTableRow(buffer, "Treatment", (Object)collection.getTreatment());
            this.addTableRow(buffer, "Mediation", (Object)collection.getMediation());
            this.addTableRow(buffer, "Nested Service Document", (Object)collection.getService());
            String[] accepts = collection.getAccepts();
            StringBuilder acceptList = new StringBuilder();
            if (accepts != null && accepts.length == 0) {
                acceptList.append("None specified");
            } else {
                for (String s : accepts) {
                    acceptList.append(s).append("<br>");
                }
            }
            this.addTableRow(buffer, "Accepts", (Object)acceptList.toString());
            List acceptsPackaging = collection.getAcceptPackaging();
            StringBuilder acceptPackagingList = new StringBuilder();
            Iterator i = acceptsPackaging.iterator();
            while (i.hasNext()) {
                SwordAcceptPackaging accept = (SwordAcceptPackaging)i.next();
                acceptPackagingList.append(accept.getContent()).append(" (").append(accept.getQualityValue()).append(")");
                if (!i.hasNext()) continue;
                acceptPackagingList.append(", ");
            }
            this.addTableRow(buffer, "Accepts Packaging", (Object)acceptPackagingList.toString());
            buffer.append("</table>");
        }
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private void showEntry(SWORDEntry entry) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        if (entry == null) {
            this.addPara(buffer, "Invalid Entry object. Unable to display details.");
        } else {
            buffer.append("<table border=\"1\" width=\"100%\">");
            buffer.append("<tr bgcolor=\"#69a5c8;\"><td colspan=\"2\"><font size=\"+2\">Entry Summary</font></td></tr>");
            String titleString = this.getTextConstructDetails((TextConstruct)entry.getSummary());
            this.addTableRow(buffer, "Title", (Object)titleString);
            this.addTableRow(buffer, "ID", (Object)entry.getId());
            this.addTableRow(buffer, "Date Updated", (Object)entry.getUpdated());
            String authorString = this.getAuthorDetails(entry.getAuthors());
            this.addTableRow(buffer, "Authors", (Object)authorString);
            String summaryString = this.getTextConstructDetails((TextConstruct)entry.getSummary());
            this.addTableRow(buffer, "Summary", (Object)summaryString);
            Content content = entry.getContent();
            String contentString = "";
            contentString = content == null ? "Not defined." : contentString + "Source: '" + content.getSource() + "', Type: '" + content.getType() + "'";
            this.addTableRow(buffer, "Content", (Object)contentString);
            Iterator links = entry.getLinks();
            StringBuffer linkBuffer = new StringBuffer();
            while (links.hasNext()) {
                Link link = (Link)links.next();
                linkBuffer.append("href: '");
                linkBuffer.append(link.getHref());
                linkBuffer.append("', href lang: '");
                linkBuffer.append(link.getHreflang());
                linkBuffer.append("', rel: '");
                linkBuffer.append(link.getRel());
                linkBuffer.append("')<br>");
            }
            if (linkBuffer.length() == 0) {
                linkBuffer.append("Not defined");
            }
            this.addTableRow(buffer, "Links", (Object)linkBuffer.toString());
            String contributorString = this.getContributorDetails(entry.getContributors());
            this.addTableRow(buffer, "Contributors", (Object)contributorString);
            String sourceString = "";
            Generator generator = entry.getGenerator();
            if (generator != null) {
                sourceString = sourceString + "Content: '" + generator.getContent() + "' <br>'";
                sourceString = sourceString + "Version: '" + generator.getVersion() + "' <br>'";
                sourceString = sourceString + "Uri: '" + generator.getUri() + "'";
            } else {
                sourceString = sourceString + "No generator defined.";
            }
            this.addTableRow(buffer, "Generator", (Object)sourceString);
            this.addTableRow(buffer, "Treatment", (Object)entry.getTreatment());
            this.addTableRow(buffer, "Verbose Description", (Object)entry.getVerboseDescription());
            this.addTableRow(buffer, "NoOp", (Object)entry.isNoOp());
            this.addTableRow(buffer, "Packaging", (Object)entry.getPackaging());
            this.addTableRow(buffer, "User Agent", (Object)entry.getUserAgent());
            buffer.append("</table>");
        }
        buffer.append("</body>");
        buffer.append("</html>");
        this.details.setText(buffer.toString());
    }

    private String getTextConstructDetails(TextConstruct data) {
        String summaryStr = "";
        if (data == null) {
            summaryStr = "Not defined";
        } else {
            summaryStr = "Content: '" + data.getContent() + "', Type: ";
            summaryStr = data.getType() != null ? summaryStr + "'" + data.getType().toString() + "'" : summaryStr + "undefined.";
        }
        return summaryStr;
    }

    private String getAuthorDetails(Iterator<Author> authors) {
        StringBuffer authorBuffer = new StringBuffer();
        while (authors.hasNext()) {
            Author a = authors.next();
            authorBuffer.append(this.getAuthorDetails(a));
        }
        if (authorBuffer.length() == 0) {
            authorBuffer.append("Not defined");
        }
        return authorBuffer.toString();
    }

    private String getContributorDetails(Iterator<Contributor> contributors) {
        StringBuffer authorBuffer = new StringBuffer();
        while (contributors.hasNext()) {
            Contributor c = contributors.next();
            authorBuffer.append(this.getAuthorDetails((Author)c));
        }
        if (authorBuffer.length() == 0) {
            authorBuffer.append("Not defined");
        }
        return authorBuffer.toString();
    }

    private String getAuthorDetails(Author author) {
        StringBuffer authorBuffer = new StringBuffer();
        authorBuffer.append(author.getName());
        authorBuffer.append(" (email: '");
        authorBuffer.append(author.getEmail());
        authorBuffer.append("', uri: '");
        authorBuffer.append(author.getUri());
        authorBuffer.append("')<br>");
        return authorBuffer.toString();
    }

    public void processDepositResponse(String url, DepositResponse response) {
        SWORDEntry entry = response.getEntry();
        Object title = entry.getTitle();
        title = title == null ? "Undefined" : entry.getTitle().getContent();
        TreeNodeWrapper wrapper = new TreeNodeWrapper(title.toString(), (Object)entry);
        DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(wrapper);
        DefaultMutableTreeNode newParentNode = this.top;
        List nodes = this.getCollectionNodes();
        for (DefaultMutableTreeNode node : nodes) {
            Collection col;
            String location;
            TreeNodeWrapper collectionWrapper;
            Object data;
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (collectionWrapper = (TreeNodeWrapper)o).getData()) instanceof Collection) || (location = (col = (Collection)data).getLocation()) == null || !location.equals(url)) continue;
            newParentNode = node;
            break;
        }
        this.treeModel.insertNodeInto(entryNode, newParentNode, newParentNode.getChildCount());
        this.services.scrollPathToVisible(new TreePath(entryNode.getPath()));
    }

    public String[] getCollectionLocations() {
        List nodes = this.getCollectionNodes();
        String[] locations = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Collection col;
            String location;
            TreeNodeWrapper collectionWrapper;
            Object data;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.get(i);
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (collectionWrapper = (TreeNodeWrapper)o).getData()) instanceof Collection) || (location = (col = (Collection)data).getLocation()) == null) continue;
            locations[i] = location;
        }
        return locations;
    }

    private List<DefaultMutableTreeNode> getCollectionNodes() {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> treeNodes = this.top.depthFirstEnumeration();
        while (treeNodes.hasMoreElements()) {
            TreeNodeWrapper wrapper;
            Object data;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeNodes.nextElement();
            Object o = node.getUserObject();
            if (!(o instanceof TreeNodeWrapper) || !((data = (wrapper = (TreeNodeWrapper)o).getData()) instanceof Collection)) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

