/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlName;

public class SWORDErrorDocument
extends SWORDEntry {
    @Deprecated
    public static final String ELEMENT_NAME = "error";
    private static final XmlName XML_NAME = new XmlName("sword", "error", "http://purl.org/net/sword/");
    private static final XmlName ATTRIBUTE_HREF_NAME = new XmlName("sword", "href", "http://purl.org/net/sword/");
    private String errorURI;

    public SWORDErrorDocument() {
        super(XML_NAME.getPrefix(), XML_NAME.getLocalName(), XML_NAME.getNamespace());
    }

    public SWORDErrorDocument(String errorURI) {
        this();
        this.errorURI = errorURI;
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    public Element marshall() {
        Element entry = new Element(this.getQualifiedName(), "http://purl.org/net/sword/");
        entry.addNamespaceDeclaration("sword", "http://purl.org/net/sword/");
        entry.addNamespaceDeclaration("atom", "http://www.w3.org/2005/Atom");
        Attribute error = new Attribute("href", this.errorURI);
        entry.addAttribute(error);
        super.marshallElements(entry);
        return entry;
    }

    public void unmarshall(Element entry) throws UnmarshallException {
        this.unmarshall(entry, null);
    }

    public SwordValidationInfo unmarshall(Element entry, Properties validationProperties) throws UnmarshallException {
        SwordValidationInfo result = super.unmarshall(entry, validationProperties);
        result.clearValidationItems();
        this.errorURI = entry.getAttributeValue(ATTRIBUTE_HREF_NAME.getLocalName());
        if (validationProperties != null) {
            result = this.validate(result, validationProperties);
        }
        return result;
    }

    protected void processUnexpectedAttributes(Element element, SwordValidationInfo info) {
        int attributeCount = element.getAttributeCount();
        Attribute attribute = null;
        for (int i = 0; i < attributeCount; ++i) {
            attribute = element.getAttribute(i);
            if (ATTRIBUTE_HREF_NAME.getLocalName().equals(attribute.getQualifiedName())) continue;
            XmlName attributeName = new XmlName(attribute.getNamespacePrefix(), attribute.getLocalName(), attribute.getNamespaceURI());
            SwordValidationInfo item = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
            item.setContentDescription(attribute.getValue());
            info.addUnmarshallAttributeInfo(item);
        }
    }

    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, validationContext);
    }

    protected SwordValidationInfo validate(SwordValidationInfo info, Properties validationContext) {
        if (this.errorURI == null) {
            info.addValidationInfo(new SwordValidationInfo(this.xmlName, ATTRIBUTE_HREF_NAME, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        } else {
            boolean validUri = true;
            if (!(!this.errorURI.startsWith("http://purl.org/net/sword/error/") || this.errorURI.equals("http://purl.org/net/sword/error/ErrorContent") || this.errorURI.equals("http://purl.org/net/sword/error/ErrorChecksumMismatch") || this.errorURI.equals("http://purl.org/net/sword/error/ErrorBadRequest") || this.errorURI.equals("http://purl.org/net/sword/error/TargetOwnerUnknown") || this.errorURI.equals("http://purl.org/net/sword/error/MediationNotAllowed"))) {
                info.addValidationInfo(new SwordValidationInfo(this.xmlName, ATTRIBUTE_HREF_NAME, "Errors in the SWORD namespace are reserved and legal values are enumerated in the SWORD 1.3 specification. Implementations MAY define their own errors, but MUST use a different namespace to do so.", SwordValidationInfoType.ERROR));
                validUri = false;
            }
            if (validUri) {
                SwordValidationInfo item = new SwordValidationInfo(this.xmlName, ATTRIBUTE_HREF_NAME);
                item.setContentDescription(this.errorURI);
                info.addAttributeValidationInfo(item);
            }
        }
        return info;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public void setErrorURI(String error) {
        this.errorURI = error;
    }
}

