/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.purl.sword.base.QualityValue;
import org.purl.sword.base.SwordContentPackageTypes;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class SwordAcceptPackaging
extends XmlElement
implements SwordElementInterface {
    private String content;
    private QualityValue qualityValue;
    private static Logger log = Logger.getLogger(SwordAcceptPackaging.class);
    public static final String ELEMENT_NAME = "acceptPackaging";
    protected static final XmlName ATTRIBUTE_Q_NAME = new XmlName("sword", "q", "http://purl.org/net/sword/");
    private static final XmlName XML_NAME = new XmlName("sword", "acceptPackaging", "http://purl.org/net/sword/");

    public SwordAcceptPackaging() {
        this(null, new QualityValue());
    }

    public SwordAcceptPackaging(String name, float value) {
        this(name, new QualityValue(value));
    }

    public SwordAcceptPackaging(String name, QualityValue value) {
        super(XML_NAME.getPrefix(), XML_NAME.getLocalName(), XML_NAME.getNamespace());
        this.initialise();
        this.setContent(name);
        this.setQualityValue(value);
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    protected final void initialise() {
        this.qualityValue = null;
        this.content = null;
    }

    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), this.xmlName.getNamespace());
        if (this.qualityValue != null) {
            Attribute qualityValueAttribute = new Attribute(ATTRIBUTE_Q_NAME.getLocalName(), this.qualityValue.toString());
            element.addAttribute(qualityValueAttribute);
        }
        if (this.content != null) {
            element.appendChild(this.content);
        }
        return element;
    }

    public SwordValidationInfo unmarshall(Element acceptPackaging, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(acceptPackaging, this.xmlName)) {
            this.handleIncorrectElement(acceptPackaging, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributeItems = new ArrayList<SwordValidationInfo>();
        try {
            int attributeCount = acceptPackaging.getAttributeCount();
            Attribute attribute = null;
            float qv = -1.0f;
            for (int i = 0; i < attributeCount; ++i) {
                SwordValidationInfo attr;
                attribute = acceptPackaging.getAttribute(i);
                if (ATTRIBUTE_Q_NAME.getLocalName().equals(attribute.getQualifiedName())) {
                    try {
                        qv = Float.parseFloat(attribute.getValue());
                        this.qualityValue = new QualityValue(qv);
                        attr = new SwordValidationInfo(this.xmlName, ATTRIBUTE_Q_NAME);
                        attr.setContentDescription("" + qv);
                        attributeItems.add(attr);
                    }
                    catch (NumberFormatException nfe) {
                        SwordValidationInfo attr2 = new SwordValidationInfo(this.xmlName, ATTRIBUTE_Q_NAME, nfe.getMessage(), SwordValidationInfoType.ERROR);
                        attr2.setContentDescription(attribute.getValue());
                        attributeItems.add(attr2);
                    }
                    continue;
                }
                attr = new SwordValidationInfo(this.xmlName, new XmlName(attribute), "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                attr.setContentDescription(attribute.getValue());
                attributeItems.add(attr);
            }
            int length = acceptPackaging.getChildCount();
            if (length > 0) {
                try {
                    this.content = this.unmarshallString(acceptPackaging);
                }
                catch (UnmarshallException ume) {
                    log.error((Object)"Error accessing the content of the acceptPackaging element");
                    validationItems.add(new SwordValidationInfo(this.xmlName, "Error unmarshalling element: " + ume.getMessage(), SwordValidationInfoType.ERROR));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in " + this.getQualifiedName() + ": " + ex.getMessage()));
            throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeItems, validationProperties);
        }
        return result;
    }

    public void unmarshall(Element element) throws UnmarshallException {
        this.unmarshall(element, null);
    }

    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    protected SwordValidationInfo validate(List<SwordValidationInfo> existing, List<SwordValidationInfo> attributeItems, Properties validationContext) {
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        result.setContentDescription(this.content);
        if (this.content == null) {
            result.addValidationInfo(new SwordValidationInfo(this.xmlName, "No content is defined. This element should have content.", SwordValidationInfoType.WARNING));
        } else if (!SwordContentPackageTypes.instance().isValidType(this.content)) {
            result.addValidationInfo(new SwordValidationInfo(this.xmlName, "The URI is not one of the types specified in http://purl.org/NET/sword-types", SwordValidationInfoType.WARNING));
        }
        result.addUnmarshallValidationInfo(existing, attributeItems);
        return result;
    }

    public final String getContent() {
        return this.content;
    }

    public final void setContent(String content) {
        this.content = content;
    }

    public final QualityValue getQualityValue() {
        return this.qualityValue;
    }

    public final void setQualityValue(QualityValue value) {
        this.qualityValue = value;
    }

    public String toString() {
        return "Summary - content: " + this.getContent() + " value: " + this.getQualityValue();
    }
}

