/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword.CollectionCollectionGenerator;
import org.dspace.sword.CommunityCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.ItemCollectionGenerator;
import org.dspace.sword.SWORDAuthenticator;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDContext;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.atom.Generator;
import org.purl.sword.base.Collection;
import org.purl.sword.base.SWORDErrorException;
import org.purl.sword.base.Service;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.Workspace;

public class ServiceDocumentManager {
    private SWORDService swordService;
    private SWORDAuthenticator swordAuth;

    public ServiceDocumentManager(SWORDService service) {
        this.swordService = service;
        this.swordAuth = new SWORDAuthenticator();
    }

    public ServiceDocument getServiceDocument() throws DSpaceSWORDException, SWORDErrorException {
        return this.getServiceDocument(null);
    }

    public ServiceDocument getServiceDocument(String url) throws DSpaceSWORDException, SWORDErrorException {
        Context context = this.swordService.getContext();
        SWORDContext swordContext = this.swordService.getSwordContext();
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        CommunityCollectionGenerator comGen = new CommunityCollectionGenerator(this.swordService);
        CollectionCollectionGenerator colGen = new CollectionCollectionGenerator(this.swordService);
        ItemCollectionGenerator itemGen = new ItemCollectionGenerator(this.swordService);
        if (context == null) {
            throw new DSpaceSWORDException("The Context is null; please set it before calling getServiceDocument");
        }
        if (swordContext == null) {
            throw new DSpaceSWORDException("The SWORD Context is null; please set it before calling getServiceDocument");
        }
        Service service = new Service("1.3", swordConfig.isNoOp(), swordConfig.isVerbose());
        service.setMaxUploadSize(swordConfig.getMaxUploadSize());
        this.addGenerator(service);
        if (url == null || urlManager.isBaseServiceDocumentUrl(url)) {
            String ws = ConfigurationManager.getProperty((String)"dspace.name");
            Workspace workspace = new Workspace();
            workspace.setTitle(ws);
            boolean swordCommunities = ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"expose-communities");
            if (swordCommunities) {
                List comms = this.swordAuth.getAllowedCommunities(swordContext);
                for (Community comm : comms) {
                    Collection scol = comGen.buildCollection((DSpaceObject)comm);
                    workspace.addCollection(scol);
                }
            } else {
                List cols = this.swordAuth.getAllowedCollections(swordContext);
                for (org.dspace.content.Collection col : cols) {
                    Collection scol = colGen.buildCollection((DSpaceObject)col);
                    workspace.addCollection(scol);
                }
            }
            service.addWorkspace(workspace);
        } else {
            DSpaceObject dso = urlManager.extractDSpaceObject(url);
            if (dso instanceof org.dspace.content.Collection) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)dso;
                Workspace workspace = new Workspace();
                workspace.setTitle(collection.getMetadata("name"));
                List items = this.swordAuth.getAllowedItems(swordContext, collection);
                for (Item item : items) {
                    Collection scol = itemGen.buildCollection((DSpaceObject)item);
                    workspace.addCollection(scol);
                }
                service.addWorkspace(workspace);
            } else if (dso instanceof Community) {
                Community community = (Community)dso;
                Workspace workspace = new Workspace();
                workspace.setTitle(community.getMetadata("name"));
                List collections = this.swordAuth.getAllowedCollections(swordContext, community);
                for (org.dspace.content.Collection collection : collections) {
                    Collection scol = colGen.buildCollection((DSpaceObject)collection);
                    workspace.addCollection(scol);
                }
                List communities = this.swordAuth.getCommunities(swordContext, community);
                for (Community comm : communities) {
                    Collection scol = comGen.buildCollection((DSpaceObject)comm);
                    workspace.addCollection(scol);
                }
                service.addWorkspace(workspace);
            }
        }
        return new ServiceDocument(service);
    }

    private void addGenerator(Service service) {
        boolean identify = ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"identify-version", (boolean)false);
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        String softwareUri = urlManager.getGeneratorUrl();
        if (identify) {
            Generator generator = new Generator();
            generator.setUri(softwareUri);
            generator.setVersion("1.3");
            service.setGenerator(generator);
        }
    }
}

