/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDService;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class SWORDMETSIngester
implements SWORDIngester {
    private SWORDService swordService;
    public static final Logger log = Logger.getLogger(SWORDMETSIngester.class);

    public DepositResult ingest(SWORDService service, Deposit deposit, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        try {
            if (!(dso instanceof Collection)) {
                throw new DSpaceSWORDException("Tried to run an ingester on wrong target type");
            }
            Collection collection = (Collection)dso;
            this.swordService = service;
            Context context = this.swordService.getContext();
            File depositFile = deposit.getFile();
            String cfg = ConfigurationManager.getProperty((String)"sword-server", (String)"mets-ingester.package-ingester");
            if (cfg == null || "".equals(cfg)) {
                cfg = "METS";
            }
            this.swordService.message("Using package manifest format: " + cfg);
            PackageIngester pi = (PackageIngester)PluginManager.getNamedPlugin(PackageIngester.class, (String)cfg);
            this.swordService.message("Loaded package ingester: " + pi.getClass().getName());
            String licence = null;
            PackageParameters params = new PackageParameters();
            params.setWorkflowEnabled(true);
            if (ConfigurationManager.getBooleanProperty((String)"sword-server", (String)"restore-mode.enable", (boolean)false)) {
                params.setRestoreModeEnabled(true);
            }
            params.setUseCollectionTemplate(ConfigurationManager.getBooleanProperty((String)"mets.default.ingest.useCollectionTemplate", (boolean)false));
            DSpaceObject ingestedObject = pi.ingest(context, (DSpaceObject)collection, depositFile, params, licence);
            if (ingestedObject == null) {
                this.swordService.message("Failed to ingest the package; throwing exception");
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/UnpackageFail", "METS package ingester failed to unpack package");
            }
            if (!(ingestedObject instanceof Item)) {
                throw new DSpaceSWORDException("DSpace Ingester returned wrong object type -- not an Item result.");
            }
            this.swordService.message("Workflow process started");
            Item installedItem = (Item)ingestedObject;
            this.setUpdatedDate(installedItem);
            this.setSlug(installedItem, deposit.getSlug());
            boolean ignore = context.ignoreAuthorization();
            context.setIgnoreAuthorization(true);
            installedItem.update();
            context.setIgnoreAuthorization(ignore);
            String handle = HandleManager.findHandle((Context)context, (DSpaceObject)installedItem);
            this.swordService.message("Ingest successful");
            this.swordService.message("Item created with internal identifier: " + installedItem.getID());
            if (handle != null) {
                this.swordService.message("Item created with external identifier: " + handle);
            } else {
                this.swordService.message("No external identifier available at this stage (item in workflow)");
            }
            DepositResult dr = new DepositResult();
            dr.setItem(installedItem);
            dr.setHandle(handle);
            dr.setTreatment(this.getTreatment());
            return dr;
        }
        catch (RuntimeException re) {
            log.error((Object)"caught exception: ", (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException((Throwable)e);
        }
    }

    private void setUpdatedDate(Item item) throws DSpaceSWORDException {
        String field = ConfigurationManager.getProperty((String)"sword-server", (String)"updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        Metadatum dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        DCDate date = new DCDate(new Date());
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, date.toString());
        this.swordService.message("Updated date added to response from item metadata where available");
    }

    private void setSlug(Item item, String slugVal) throws DSpaceSWORDException {
        if (slugVal == null) {
            return;
        }
        String field = ConfigurationManager.getProperty((String)"sword-server", (String)"slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        Metadatum dc = this.configToDC(field, null);
        item.clearMetadata(dc.schema, dc.element, dc.qualifier, "*");
        item.addMetadata(dc.schema, dc.element, dc.qualifier, null, slugVal);
        this.swordService.message("Slug value set in response where available");
    }

    private Metadatum configToDC(String config, String def) {
        Metadatum dcv = new Metadatum();
        dcv.schema = def;
        dcv.element = def;
        dcv.qualifier = def;
        StringTokenizer stz = new StringTokenizer(config, ".");
        dcv.schema = stz.nextToken();
        dcv.element = stz.nextToken();
        if (stz.hasMoreTokens()) {
            dcv.qualifier = stz.nextToken();
        }
        return dcv;
    }

    private String getTreatment() throws DSpaceSWORDException {
        return "The package has been deposited into DSpace.  Each file has been unpacked and provided with a unique identifier.  The metadata in the manifest has been extracted and attached to the DSpace item, which has been provided with an identifier leading to an HTML splash page.";
    }
}

