/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.purl.sword.atom.Generator;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class Source
extends XmlElement
implements SwordElementInterface {
    private static final XmlName XML_NAME = new XmlName("atom", "source", "http://www.w3.org/2005/Atom");
    private Generator generator;
    private static Logger log = Logger.getLogger(Source.class);

    public Source() {
        super(XML_NAME);
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    public Element marshall() {
        Element source = new Element(this.getQualifiedName(), this.xmlName.getNamespace());
        if (this.generator != null) {
            source.appendChild((Node)this.generator.marshall());
        }
        return source;
    }

    public void unmarshall(Element source) throws UnmarshallException {
        this.unmarshall(source, null);
    }

    public SwordValidationInfo unmarshall(Element source, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(source, this.xmlName.getLocalName(), "http://www.w3.org/2005/Atom")) {
            return this.handleIncorrectElement(source, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList attributeItems = new ArrayList();
        try {
            this.processUnexpectedAttributes(source, attributeItems);
            Elements elements = source.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                element = elements.get(i);
                if (this.isInstanceOf(element, Generator.elementName())) {
                    this.generator = new Generator();
                    this.generator.unmarshall(element);
                    continue;
                }
                SwordValidationInfo info = new SwordValidationInfo(new XmlName(element), "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(element.getValue());
                validationItems.add(info);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to parse an element in Source: " + ex.getMessage()));
            throw new UnmarshallException("Unable to parse an element in Source", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeItems, validationProperties);
        }
        return result;
    }

    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    public SwordValidationInfo validate(List<SwordValidationInfo> elements, List<SwordValidationInfo> attributes, Properties validationContext) {
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        result.addUnmarshallValidationInfo(elements, attributes);
        return result;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }
}

