/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.purl.sword.client.PostDestination;

public class ClientOptions {
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_POST = "post";
    public static final String TYPE_MULTI_POST = "multipost";
    private String accessType = null;
    private String proxyHost = null;
    private int proxyPort = 8080;
    private String username = null;
    private String password = null;
    private String href = null;
    private String filename = null;
    private String filetype = null;
    private boolean noCapture = false;
    private String slug = null;
    private boolean noOp = false;
    private boolean verbose = false;
    private String onBehalfOf = null;
    private String formatNamespace = null;
    private boolean checksumError = false;
    private static Logger log = Logger.getLogger(ClientOptions.class);
    private List<PostDestination> multiPost = new ArrayList();
    private static final Pattern multiPattern = Pattern.compile("(.*?)(\\[(.*?)\\]){0,1}(:(.*)){0,1}@(http://.*)");
    private boolean guiMode = true;
    private boolean md5 = false;

    public boolean parseOptions(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-md5".equals(args[i])) {
                    this.md5 = true;
                }
                if ("-noOp".equals(args[i])) {
                    this.noOp = true;
                }
                if ("-verbose".equals(args[i])) {
                    this.verbose = true;
                }
                if ("-cmd".equals(args[i])) {
                    this.guiMode = false;
                }
                if ("-gui".equals(args[i])) {
                    this.guiMode = true;
                }
                if ("-host".equals(args[i])) {
                    this.proxyHost = args[++i];
                }
                if ("-port".equals(args[i])) {
                    this.proxyPort = Integer.parseInt(args[++i]);
                }
                if ("-u".equals(args[i])) {
                    this.username = args[++i];
                }
                if ("-p".equals(args[i])) {
                    this.password = args[++i];
                }
                if ("-href".equals(args[i])) {
                    this.href = args[++i];
                }
                if ("-help".equals(args[i])) {
                    return false;
                }
                if ("-t".equals(args[i])) {
                    this.accessType = args[++i];
                }
                if ("-file".equals(args[i])) {
                    this.filename = args[++i];
                }
                if ("-filetype".equals(args[i])) {
                    this.filetype = args[++i];
                }
                if ("-slug".equals(args[i])) {
                    this.slug = args[++i];
                }
                if ("-onBehalfOf".equals(args[i])) {
                    this.onBehalfOf = args[++i];
                }
                if ("-formatNamespace".equals(args[i])) {
                    this.formatNamespace = args[++i];
                }
                if ("-checksumError".equals(args[i])) {
                    ++i;
                    this.checksumError = true;
                }
                if ("-dest".equals(args[i])) {
                    Matcher m;
                    if (!(m = multiPattern.matcher(args[++i])).matches()) {
                        log.debug((Object)("Error with dest parameter. Ignoring value: " + args[i]));
                    } else {
                        int numGroups = m.groupCount();
                        for (int g = 0; g <= numGroups; ++g) {
                            log.debug((Object)("Group (" + g + ") is: " + m.group(g)));
                        }
                        String username = m.group(1);
                        String onBehalfOf = m.group(3);
                        String password = m.group(5);
                        String url = m.group(6);
                        PostDestination destination = new PostDestination(url, username, password, onBehalfOf);
                        this.multiPost.add(destination);
                    }
                }
                if (!"-nocapture".equals(args[i])) continue;
                ++i;
                this.noCapture = true;
            }
            if (this.href == null && TYPE_SERVICE.equals(this.accessType)) {
                log.error((Object)"No href specified.");
                return false;
            }
            if (this.multiPost.size() == 0 && TYPE_MULTI_POST.equals(this.accessType)) {
                log.error((Object)"No destinations specified");
                return false;
            }
            if (this.accessType == null && !this.guiMode) {
                log.error((Object)"No access type specified");
                return false;
            }
            if (this.username == null && this.password != null || this.username != null && this.password == null) {
                log.error((Object)"The username and/or password are not specified. If one is specified, the other must also be specified.");
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error((Object)"Error with parameters.");
            return false;
        }
        return true;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFiletype() {
        return this.filetype;
    }

    public void setFiletype(String filetype) {
        this.filetype = filetype;
    }

    public boolean isGuiMode() {
        return this.guiMode;
    }

    public void setGuiMode(boolean guiMode) {
        this.guiMode = guiMode;
    }

    public boolean isMd5() {
        return this.md5;
    }

    public void setMd5(boolean md5) {
        this.md5 = md5;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public String getFormatNamespace() {
        return this.formatNamespace;
    }

    public void setFormatNamespace(String formatNamespace) {
        this.formatNamespace = formatNamespace;
    }

    public boolean getChecksumError() {
        return this.checksumError;
    }

    public void setChecksumError(boolean checksumError) {
        this.checksumError = checksumError;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public Iterator<PostDestination> getMultiPost() {
        return this.multiPost.iterator();
    }

    public boolean isNoCapture() {
        return this.noCapture;
    }
}

